<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for X509TokenContainerType StructType
 * @subpackage Structs
 */
class X509TokenContainerType extends AbstractStructBase
{
    /**
     * The X509TokenInfo
     * Meta information extracted from the WSDL
     * - ref: osci:X509TokenInfo
     * @var \StructType\X509TokenInfo
     */
    public $X509TokenInfo;
    /**
     * The validateCompleted
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $validateCompleted;
    /**
     * Constructor method for X509TokenContainerType
     * @uses X509TokenContainerType::setX509TokenInfo()
     * @uses X509TokenContainerType::setValidateCompleted()
     * @param \StructType\X509TokenInfo $x509TokenInfo
     * @param bool $validateCompleted
     */
    public function __construct(\StructType\X509TokenInfo $x509TokenInfo = null, $validateCompleted = false)
    {
        $this
            ->setX509TokenInfo($x509TokenInfo)
            ->setValidateCompleted($validateCompleted);
    }
    /**
     * Get X509TokenInfo value
     * @return \StructType\X509TokenInfo|null
     */
    public function getX509TokenInfo()
    {
        return $this->X509TokenInfo;
    }
    /**
     * Set X509TokenInfo value
     * @param \StructType\X509TokenInfo $x509TokenInfo
     * @return \StructType\X509TokenContainerType
     */
    public function setX509TokenInfo(\StructType\X509TokenInfo $x509TokenInfo = null)
    {
        $this->X509TokenInfo = $x509TokenInfo;
        return $this;
    }
    /**
     * Get validateCompleted value
     * @return bool|null
     */
    public function getValidateCompleted()
    {
        return $this->validateCompleted;
    }
    /**
     * Set validateCompleted value
     * @param bool $validateCompleted
     * @return \StructType\X509TokenContainerType
     */
    public function setValidateCompleted($validateCompleted = false)
    {
        // validation for constraint: boolean
        if (!is_null($validateCompleted) && !is_bool($validateCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validateCompleted, true), gettype($validateCompleted)), __LINE__);
        }
        $this->validateCompleted = $validateCompleted;
        return $this;
    }
}
