<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarnList StructType
 * Meta information extracted from the WSDL
 * - documentation: Liste der Warnungen.
 * @subpackage Structs
 */
class WarnList extends AbstractStructBase
{
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Hier wird die Warnung mit ihren Paramtern eingetragen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecordType[]
     */
    public $Warning;
    /**
     * Constructor method for WarnList
     * @uses WarnList::setWarning()
     * @param \StructType\RecordType[] $warning
     */
    public function __construct(array $warning = array())
    {
        $this
            ->setWarning($warning);
    }
    /**
     * Get Warning value
     * @return \StructType\RecordType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $warnListWarningItem) {
            // validation for constraint: itemType
            if (!$warnListWarningItem instanceof \StructType\RecordType) {
                $invalidValues[] = is_object($warnListWarningItem) ? get_class($warnListWarningItem) : sprintf('%s(%s)', gettype($warnListWarningItem), var_export($warnListWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\RecordType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordType[] $warning
     * @return \StructType\WarnList
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordType $item
     * @return \StructType\WarnList
     */
    public function addToWarning(\StructType\RecordType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecordType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\RecordType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
