<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportReport StructType
 * Meta information extracted from the WSDL
 * - documentation: Falls der TransportReport signiert ist, findet sich hier die Signatur. | Dieser Container umfasst alle Daten des Transportauftrags, auf dessen Ausführung sich der TransportReport bezieht. Zu den Informationen gehören die
 * Identifizierung von Absender und (einem oder mehreren) Empfängern, Metainformation zu Inhalt und Identität der zu transportierenden Fachnachricht (Payload) sowie weitere Attribute, die Auslieferung, Quittungen und Service Qualität
 * betreffen.Weitere Informationen zu diesem Objekt sind in zu finden. | Der TransportReport ist die Struktur des durch XTA standardisierten Transportprotokolls. Neben den übermittelten Nachrichten ruft das Fachverfahren (in den Rollen Autor und Leser)
 * über den Webservice-Client Zusatzinformationen über den Transportauftrag und die Transportereignisse vom XTA-WS ab. Um Autor und Leser die Möglichkeit zu geben, die Abarbeitung ihrer Transportaufträge zu überwachen, erstellen Sender und
 * Empfänger Transportprotokolle, die in einer XML-Struktur des Typs TransportReport dargestellt und für Abruf und Auswertung bereit liegen.Die Datenstruktur aggregiert die Information zum erteilten Transportauftrag, zum Verlauf des sich
 * anschließenden Transports einschließlich Zertifikatsüberprüfungen mit Ergebnissen.
 * @subpackage Structs
 */
class TransportReport extends AbstractStructBase
{
    /**
     * The MessageMetaData
     * Meta information extracted from the WSDL
     * - ref: oscimeta:MessageMetaData
     * @var \StructType\MessageMetaData
     */
    public $MessageMetaData;
    /**
     * The ReportTime
     * Meta information extracted from the WSDL
     * - documentation: Zeitpunkt der letzten Aktualisierung des Protokolls. Ist bei Fortschreibung des Protokolls zu überschreiben.
     * @var string
     */
    public $ReportTime;
    /**
     * The XTAServerIdentity
     * Meta information extracted from the WSDL
     * - documentation: Hier protokolliert der den TransportReport erstellende Prozess seine Identität als Software-Instanz, indem er z.B. die Server-IP-Adresse oder die URI seines XTA-WS einträgt.
     * @var string
     */
    public $XTAServerIdentity;
    /**
     * The MessageStatus
     * Meta information extracted from the WSDL
     * - documentation: Enthält Information über den Veraluf des Transports. Es werden hier Listen mit aufgetretenen Fehler-, Warnungs- und Informationsmeldungen geführt. Außerdem ist nach Schließung des Transportauftrags im Feld Status eine
     * "Schnell-Info" verfügbar.
     * @var \StructType\MessageStatusType
     */
    public $MessageStatus;
    /**
     * The AdditionalReports
     * Meta information extracted from the WSDL
     * - documentation: Hier sind weitere Prüfberichte abgelegt bzw. abzulegen, welche das XTA-Protokoll (TransportReport) ergänzen sollen.
     * - minOccurs: 0
     * @var \StructType\AdditionalReportListType
     */
    public $AdditionalReports;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * Constructor method for TransportReport
     * @uses TransportReport::setMessageMetaData()
     * @uses TransportReport::setReportTime()
     * @uses TransportReport::setXTAServerIdentity()
     * @uses TransportReport::setMessageStatus()
     * @uses TransportReport::setAdditionalReports()
     * @uses TransportReport::setSignature()
     * @param \StructType\MessageMetaData $messageMetaData
     * @param string $reportTime
     * @param string $xTAServerIdentity
     * @param \StructType\MessageStatusType $messageStatus
     * @param \StructType\AdditionalReportListType $additionalReports
     * @param \StructType\SignatureType $signature
     */
    public function __construct(\StructType\MessageMetaData $messageMetaData = null, $reportTime = null, $xTAServerIdentity = null, \StructType\MessageStatusType $messageStatus = null, \StructType\AdditionalReportListType $additionalReports = null, \StructType\SignatureType $signature = null)
    {
        $this
            ->setMessageMetaData($messageMetaData)
            ->setReportTime($reportTime)
            ->setXTAServerIdentity($xTAServerIdentity)
            ->setMessageStatus($messageStatus)
            ->setAdditionalReports($additionalReports)
            ->setSignature($signature);
    }
    /**
     * Get MessageMetaData value
     * @return \StructType\MessageMetaData|null
     */
    public function getMessageMetaData()
    {
        return $this->MessageMetaData;
    }
    /**
     * Set MessageMetaData value
     * @param \StructType\MessageMetaData $messageMetaData
     * @return \StructType\TransportReport
     */
    public function setMessageMetaData(\StructType\MessageMetaData $messageMetaData = null)
    {
        $this->MessageMetaData = $messageMetaData;
        return $this;
    }
    /**
     * Get ReportTime value
     * @return string|null
     */
    public function getReportTime()
    {
        return $this->ReportTime;
    }
    /**
     * Set ReportTime value
     * @param string $reportTime
     * @return \StructType\TransportReport
     */
    public function setReportTime($reportTime = null)
    {
        // validation for constraint: string
        if (!is_null($reportTime) && !is_string($reportTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportTime, true), gettype($reportTime)), __LINE__);
        }
        $this->ReportTime = $reportTime;
        return $this;
    }
    /**
     * Get XTAServerIdentity value
     * @return string|null
     */
    public function getXTAServerIdentity()
    {
        return $this->XTAServerIdentity;
    }
    /**
     * Set XTAServerIdentity value
     * @param string $xTAServerIdentity
     * @return \StructType\TransportReport
     */
    public function setXTAServerIdentity($xTAServerIdentity = null)
    {
        // validation for constraint: string
        if (!is_null($xTAServerIdentity) && !is_string($xTAServerIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xTAServerIdentity, true), gettype($xTAServerIdentity)), __LINE__);
        }
        $this->XTAServerIdentity = $xTAServerIdentity;
        return $this;
    }
    /**
     * Get MessageStatus value
     * @return \StructType\MessageStatusType|null
     */
    public function getMessageStatus()
    {
        return $this->MessageStatus;
    }
    /**
     * Set MessageStatus value
     * @param \StructType\MessageStatusType $messageStatus
     * @return \StructType\TransportReport
     */
    public function setMessageStatus(\StructType\MessageStatusType $messageStatus = null)
    {
        $this->MessageStatus = $messageStatus;
        return $this;
    }
    /**
     * Get AdditionalReports value
     * @return \StructType\AdditionalReportListType|null
     */
    public function getAdditionalReports()
    {
        return $this->AdditionalReports;
    }
    /**
     * Set AdditionalReports value
     * @param \StructType\AdditionalReportListType $additionalReports
     * @return \StructType\TransportReport
     */
    public function setAdditionalReports(\StructType\AdditionalReportListType $additionalReports = null)
    {
        $this->AdditionalReports = $additionalReports;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\TransportReport
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
}
