<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TokenApplication StructType
 * @subpackage Structs
 */
class TokenApplication extends AbstractStructBase
{
    /**
     * The TimeInstant
     * @var string
     */
    public $TimeInstant;
    /**
     * The MsgItemRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MsgItemRef;
    /**
     * The validateResultRef
     * @var string
     */
    public $validateResultRef;
    /**
     * The ocspNoCache
     * @var bool
     */
    public $ocspNoCache;
    /**
     * Constructor method for TokenApplication
     * @uses TokenApplication::setTimeInstant()
     * @uses TokenApplication::setMsgItemRef()
     * @uses TokenApplication::setValidateResultRef()
     * @uses TokenApplication::setOcspNoCache()
     * @param string $timeInstant
     * @param string $msgItemRef
     * @param string $validateResultRef
     * @param bool $ocspNoCache
     */
    public function __construct($timeInstant = null, $msgItemRef = null, $validateResultRef = null, $ocspNoCache = null)
    {
        $this
            ->setTimeInstant($timeInstant)
            ->setMsgItemRef($msgItemRef)
            ->setValidateResultRef($validateResultRef)
            ->setOcspNoCache($ocspNoCache);
    }
    /**
     * Get TimeInstant value
     * @return string|null
     */
    public function getTimeInstant()
    {
        return $this->TimeInstant;
    }
    /**
     * Set TimeInstant value
     * @param string $timeInstant
     * @return \StructType\TokenApplication
     */
    public function setTimeInstant($timeInstant = null)
    {
        // validation for constraint: string
        if (!is_null($timeInstant) && !is_string($timeInstant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeInstant, true), gettype($timeInstant)), __LINE__);
        }
        $this->TimeInstant = $timeInstant;
        return $this;
    }
    /**
     * Get MsgItemRef value
     * @return string|null
     */
    public function getMsgItemRef()
    {
        return $this->MsgItemRef;
    }
    /**
     * Set MsgItemRef value
     * @param string $msgItemRef
     * @return \StructType\TokenApplication
     */
    public function setMsgItemRef($msgItemRef = null)
    {
        // validation for constraint: string
        if (!is_null($msgItemRef) && !is_string($msgItemRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msgItemRef, true), gettype($msgItemRef)), __LINE__);
        }
        $this->MsgItemRef = $msgItemRef;
        return $this;
    }
    /**
     * Get validateResultRef value
     * @return string|null
     */
    public function getValidateResultRef()
    {
        return $this->validateResultRef;
    }
    /**
     * Set validateResultRef value
     * @param string $validateResultRef
     * @return \StructType\TokenApplication
     */
    public function setValidateResultRef($validateResultRef = null)
    {
        // validation for constraint: string
        if (!is_null($validateResultRef) && !is_string($validateResultRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validateResultRef, true), gettype($validateResultRef)), __LINE__);
        }
        $this->validateResultRef = $validateResultRef;
        return $this;
    }
    /**
     * Get ocspNoCache value
     * @return bool|null
     */
    public function getOcspNoCache()
    {
        return $this->ocspNoCache;
    }
    /**
     * Set ocspNoCache value
     * @param bool $ocspNoCache
     * @return \StructType\TokenApplication
     */
    public function setOcspNoCache($ocspNoCache = null)
    {
        // validation for constraint: boolean
        if (!is_null($ocspNoCache) && !is_bool($ocspNoCache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ocspNoCache, true), gettype($ocspNoCache)), __LINE__);
        }
        $this->ocspNoCache = $ocspNoCache;
        return $this;
    }
}
