<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiptInfoType StructType
 * @subpackage Structs
 */
class ReceiptInfoType extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Id;
    /**
     * The MessageID
     * Meta information extracted from the WSDL
     * - ref: wsa:MessageID
     * @var \StructType\AttributedURIType
     */
    public $MessageID;
    /**
     * The MsgTimeStamps
     * Meta information extracted from the WSDL
     * - ref: osci:MsgTimeStamps
     * @var \StructType\MsgTimeStampsType
     */
    public $MsgTimeStamps;
    /**
     * The RelatesTo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: wsa:RelatesTo
     * @var \StructType\RelatesToType[]
     */
    public $RelatesTo;
    /**
     * The To
     * @var \StructType\EndpointReferenceType
     */
    public $To;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: wsa:From
     * @var \StructType\EndpointReferenceType
     */
    public $From;
    /**
     * The ReplyTo
     * Meta information extracted from the WSDL
     * - ref: wsa:ReplyTo
     * @var \StructType\EndpointReferenceType
     */
    public $ReplyTo;
    /**
     * The RequestEcho
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestEcho;
    /**
     * The MessageMetaData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: oscimeta:MessageMetaData
     * @var \StructType\MessageMetaData
     */
    public $MessageMetaData;
    /**
     * The ReceiptIssuerRole
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReceiptIssuerRole;
    /**
     * Constructor method for ReceiptInfoType
     * @uses ReceiptInfoType::setId()
     * @uses ReceiptInfoType::setMessageID()
     * @uses ReceiptInfoType::setMsgTimeStamps()
     * @uses ReceiptInfoType::setRelatesTo()
     * @uses ReceiptInfoType::setTo()
     * @uses ReceiptInfoType::setFrom()
     * @uses ReceiptInfoType::setReplyTo()
     * @uses ReceiptInfoType::setRequestEcho()
     * @uses ReceiptInfoType::setMessageMetaData()
     * @uses ReceiptInfoType::setReceiptIssuerRole()
     * @param string $id
     * @param \StructType\AttributedURIType $messageID
     * @param \StructType\MsgTimeStampsType $msgTimeStamps
     * @param \StructType\RelatesToType[] $relatesTo
     * @param \StructType\EndpointReferenceType $to
     * @param \StructType\EndpointReferenceType $from
     * @param \StructType\EndpointReferenceType $replyTo
     * @param string $requestEcho
     * @param \StructType\MessageMetaData $messageMetaData
     * @param string $receiptIssuerRole
     */
    public function __construct($id = null, \StructType\AttributedURIType $messageID = null, \StructType\MsgTimeStampsType $msgTimeStamps = null, array $relatesTo = array(), \StructType\EndpointReferenceType $to = null, \StructType\EndpointReferenceType $from = null, \StructType\EndpointReferenceType $replyTo = null, $requestEcho = null, \StructType\MessageMetaData $messageMetaData = null, $receiptIssuerRole = null)
    {
        $this
            ->setId($id)
            ->setMessageID($messageID)
            ->setMsgTimeStamps($msgTimeStamps)
            ->setRelatesTo($relatesTo)
            ->setTo($to)
            ->setFrom($from)
            ->setReplyTo($replyTo)
            ->setRequestEcho($requestEcho)
            ->setMessageMetaData($messageMetaData)
            ->setReceiptIssuerRole($receiptIssuerRole);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ReceiptInfoType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MessageID value
     * @return \StructType\AttributedURIType|null
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param \StructType\AttributedURIType $messageID
     * @return \StructType\ReceiptInfoType
     */
    public function setMessageID(\StructType\AttributedURIType $messageID = null)
    {
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get MsgTimeStamps value
     * @return \StructType\MsgTimeStampsType|null
     */
    public function getMsgTimeStamps()
    {
        return $this->MsgTimeStamps;
    }
    /**
     * Set MsgTimeStamps value
     * @param \StructType\MsgTimeStampsType $msgTimeStamps
     * @return \StructType\ReceiptInfoType
     */
    public function setMsgTimeStamps(\StructType\MsgTimeStampsType $msgTimeStamps = null)
    {
        $this->MsgTimeStamps = $msgTimeStamps;
        return $this;
    }
    /**
     * Get RelatesTo value
     * @return \StructType\RelatesToType[]|null
     */
    public function getRelatesTo()
    {
        return $this->RelatesTo;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatesTo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatesTo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatesToForArrayConstraintsFromSetRelatesTo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receiptInfoTypeRelatesToItem) {
            // validation for constraint: itemType
            if (!$receiptInfoTypeRelatesToItem instanceof \StructType\RelatesToType) {
                $invalidValues[] = is_object($receiptInfoTypeRelatesToItem) ? get_class($receiptInfoTypeRelatesToItem) : sprintf('%s(%s)', gettype($receiptInfoTypeRelatesToItem), var_export($receiptInfoTypeRelatesToItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatesTo property can only contain items of type \StructType\RelatesToType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatesTo value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatesToType[] $relatesTo
     * @return \StructType\ReceiptInfoType
     */
    public function setRelatesTo(array $relatesTo = array())
    {
        // validation for constraint: array
        if ('' !== ($relatesToArrayErrorMessage = self::validateRelatesToForArrayConstraintsFromSetRelatesTo($relatesTo))) {
            throw new \InvalidArgumentException($relatesToArrayErrorMessage, __LINE__);
        }
        $this->RelatesTo = $relatesTo;
        return $this;
    }
    /**
     * Add item to RelatesTo value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatesToType $item
     * @return \StructType\ReceiptInfoType
     */
    public function addToRelatesTo(\StructType\RelatesToType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatesToType) {
            throw new \InvalidArgumentException(sprintf('The RelatesTo property can only contain items of type \StructType\RelatesToType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatesTo[] = $item;
        return $this;
    }
    /**
     * Get To value
     * @return \StructType\EndpointReferenceType|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param \StructType\EndpointReferenceType $to
     * @return \StructType\ReceiptInfoType
     */
    public function setTo(\StructType\EndpointReferenceType $to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get From value
     * @return \StructType\EndpointReferenceType|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param \StructType\EndpointReferenceType $from
     * @return \StructType\ReceiptInfoType
     */
    public function setFrom(\StructType\EndpointReferenceType $from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get ReplyTo value
     * @return \StructType\EndpointReferenceType|null
     */
    public function getReplyTo()
    {
        return $this->ReplyTo;
    }
    /**
     * Set ReplyTo value
     * @param \StructType\EndpointReferenceType $replyTo
     * @return \StructType\ReceiptInfoType
     */
    public function setReplyTo(\StructType\EndpointReferenceType $replyTo = null)
    {
        $this->ReplyTo = $replyTo;
        return $this;
    }
    /**
     * Get RequestEcho value
     * @return string|null
     */
    public function getRequestEcho()
    {
        return $this->RequestEcho;
    }
    /**
     * Set RequestEcho value
     * @param string $requestEcho
     * @return \StructType\ReceiptInfoType
     */
    public function setRequestEcho($requestEcho = null)
    {
        // validation for constraint: string
        if (!is_null($requestEcho) && !is_string($requestEcho)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestEcho, true), gettype($requestEcho)), __LINE__);
        }
        $this->RequestEcho = $requestEcho;
        return $this;
    }
    /**
     * Get MessageMetaData value
     * @return \StructType\MessageMetaData|null
     */
    public function getMessageMetaData()
    {
        return $this->MessageMetaData;
    }
    /**
     * Set MessageMetaData value
     * @param \StructType\MessageMetaData $messageMetaData
     * @return \StructType\ReceiptInfoType
     */
    public function setMessageMetaData(\StructType\MessageMetaData $messageMetaData = null)
    {
        $this->MessageMetaData = $messageMetaData;
        return $this;
    }
    /**
     * Get ReceiptIssuerRole value
     * @return string|null
     */
    public function getReceiptIssuerRole()
    {
        return $this->ReceiptIssuerRole;
    }
    /**
     * Set ReceiptIssuerRole value
     * @param string $receiptIssuerRole
     * @return \StructType\ReceiptInfoType
     */
    public function setReceiptIssuerRole($receiptIssuerRole = null)
    {
        // validation for constraint: string
        if (!is_null($receiptIssuerRole) && !is_string($receiptIssuerRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptIssuerRole, true), gettype($receiptIssuerRole)), __LINE__);
        }
        $this->ReceiptIssuerRole = $receiptIssuerRole;
        return $this;
    }
}
