<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Logical identifier and optional security tokens of that entity (binary, may carry SAML, too)
 * @subpackage Structs
 */
class PartyType extends AbstractStructBase
{
    /**
     * The Identifier
     * @var \StructType\PartyIdentifierType
     */
    public $Identifier;
    /**
     * The SecurityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: oscimeta:SecurityToken
     * @var \StructType\SecurityToken[]
     */
    public $SecurityToken;
    /**
     * Constructor method for PartyType
     * @uses PartyType::setIdentifier()
     * @uses PartyType::setSecurityToken()
     * @param \StructType\PartyIdentifierType $identifier
     * @param \StructType\SecurityToken[] $securityToken
     */
    public function __construct(\StructType\PartyIdentifierType $identifier = null, array $securityToken = array())
    {
        $this
            ->setIdentifier($identifier)
            ->setSecurityToken($securityToken);
    }
    /**
     * Get Identifier value
     * @return \StructType\PartyIdentifierType|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param \StructType\PartyIdentifierType $identifier
     * @return \StructType\PartyType
     */
    public function setIdentifier(\StructType\PartyIdentifierType $identifier = null)
    {
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get SecurityToken value
     * @return \StructType\SecurityToken[]|null
     */
    public function getSecurityToken()
    {
        return $this->SecurityToken;
    }
    /**
     * This method is responsible for validating the values passed to the setSecurityToken method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSecurityToken method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSecurityTokenForArrayConstraintsFromSetSecurityToken(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyTypeSecurityTokenItem) {
            // validation for constraint: itemType
            if (!$partyTypeSecurityTokenItem instanceof \StructType\SecurityToken) {
                $invalidValues[] = is_object($partyTypeSecurityTokenItem) ? get_class($partyTypeSecurityTokenItem) : sprintf('%s(%s)', gettype($partyTypeSecurityTokenItem), var_export($partyTypeSecurityTokenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SecurityToken property can only contain items of type \StructType\SecurityToken, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SecurityToken value
     * @throws \InvalidArgumentException
     * @param \StructType\SecurityToken[] $securityToken
     * @return \StructType\PartyType
     */
    public function setSecurityToken(array $securityToken = array())
    {
        // validation for constraint: array
        if ('' !== ($securityTokenArrayErrorMessage = self::validateSecurityTokenForArrayConstraintsFromSetSecurityToken($securityToken))) {
            throw new \InvalidArgumentException($securityTokenArrayErrorMessage, __LINE__);
        }
        $this->SecurityToken = $securityToken;
        return $this;
    }
    /**
     * Add item to SecurityToken value
     * @throws \InvalidArgumentException
     * @param \StructType\SecurityToken $item
     * @return \StructType\PartyType
     */
    public function addToSecurityToken(\StructType\SecurityToken $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SecurityToken) {
            throw new \InvalidArgumentException(sprintf('The SecurityToken property can only contain items of type \StructType\SecurityToken, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SecurityToken[] = $item;
        return $this;
    }
}
