<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatorContentType StructType
 * @subpackage Structs
 */
class OperatorContentType extends AbstractStructBase
{
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - choice: Policy | All | ExactlyOne | PolicyReference |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - ref: tns:Policy
     * @var \StructType\Policy
     */
    public $Policy;
    /**
     * The All
     * Meta information extracted from the WSDL
     * - choice: Policy | All | ExactlyOne | PolicyReference |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - ref: tns:All
     * @var \StructType\OperatorContentType
     */
    public $All;
    /**
     * The ExactlyOne
     * Meta information extracted from the WSDL
     * - choice: Policy | All | ExactlyOne | PolicyReference |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - ref: tns:ExactlyOne
     * @var \StructType\OperatorContentType
     */
    public $ExactlyOne;
    /**
     * The PolicyReference
     * Meta information extracted from the WSDL
     * - choice: Policy | All | ExactlyOne | PolicyReference |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - ref: tns:PolicyReference
     * @var \StructType\PolicyReference
     */
    public $PolicyReference;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for OperatorContentType
     * @uses OperatorContentType::setPolicy()
     * @uses OperatorContentType::setAll()
     * @uses OperatorContentType::setExactlyOne()
     * @uses OperatorContentType::setPolicyReference()
     * @uses OperatorContentType::setAny()
     * @param \StructType\Policy $policy
     * @param \StructType\OperatorContentType $all
     * @param \StructType\OperatorContentType $exactlyOne
     * @param \StructType\PolicyReference $policyReference
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\Policy $policy = null, \StructType\OperatorContentType $all = null, \StructType\OperatorContentType $exactlyOne = null, \StructType\PolicyReference $policyReference = null, \DOMDocument $any = null)
    {
        $this
            ->setPolicy($policy)
            ->setAll($all)
            ->setExactlyOne($exactlyOne)
            ->setPolicyReference($policyReference)
            ->setAny($any);
    }
    /**
     * Get Policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return isset($this->Policy) ? $this->Policy : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePolicyForChoiceConstraintsFromSetPolicy($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'All',
            'ExactlyOne',
            'PolicyReference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Policy can\'t be set as the property %s is already set. Only one property must be set among these properties: Policy, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Policy value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Policy $policy
     * @return \StructType\OperatorContentType
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        // validation for constraint: choice(Policy, All, ExactlyOne, PolicyReference, )
        if ('' !== ($policyChoiceErrorMessage = self::validatePolicyForChoiceConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyChoiceErrorMessage, __LINE__);
        }
        if (is_null($policy) || (is_array($policy) && empty($policy))) {
            unset($this->Policy);
        } else {
            $this->Policy = $policy;
        }
        return $this;
    }
    /**
     * Get All value
     * @return \StructType\OperatorContentType|null
     */
    public function getAll()
    {
        return isset($this->All) ? $this->All : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAll method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAll method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAllForChoiceConstraintsFromSetAll($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Policy',
            'ExactlyOne',
            'PolicyReference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property All can\'t be set as the property %s is already set. Only one property must be set among these properties: All, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set All value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorContentType $all
     * @return \StructType\OperatorContentType
     */
    public function setAll(\StructType\OperatorContentType $all = null)
    {
        // validation for constraint: choice(Policy, All, ExactlyOne, PolicyReference, )
        if ('' !== ($allChoiceErrorMessage = self::validateAllForChoiceConstraintsFromSetAll($all))) {
            throw new \InvalidArgumentException($allChoiceErrorMessage, __LINE__);
        }
        if (is_null($all) || (is_array($all) && empty($all))) {
            unset($this->All);
        } else {
            $this->All = $all;
        }
        return $this;
    }
    /**
     * Get ExactlyOne value
     * @return \StructType\OperatorContentType|null
     */
    public function getExactlyOne()
    {
        return isset($this->ExactlyOne) ? $this->ExactlyOne : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExactlyOne method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExactlyOne method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExactlyOneForChoiceConstraintsFromSetExactlyOne($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Policy',
            'All',
            'PolicyReference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ExactlyOne can\'t be set as the property %s is already set. Only one property must be set among these properties: ExactlyOne, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ExactlyOne value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorContentType $exactlyOne
     * @return \StructType\OperatorContentType
     */
    public function setExactlyOne(\StructType\OperatorContentType $exactlyOne = null)
    {
        // validation for constraint: choice(Policy, All, ExactlyOne, PolicyReference, )
        if ('' !== ($exactlyOneChoiceErrorMessage = self::validateExactlyOneForChoiceConstraintsFromSetExactlyOne($exactlyOne))) {
            throw new \InvalidArgumentException($exactlyOneChoiceErrorMessage, __LINE__);
        }
        if (is_null($exactlyOne) || (is_array($exactlyOne) && empty($exactlyOne))) {
            unset($this->ExactlyOne);
        } else {
            $this->ExactlyOne = $exactlyOne;
        }
        return $this;
    }
    /**
     * Get PolicyReference value
     * @return \StructType\PolicyReference|null
     */
    public function getPolicyReference()
    {
        return isset($this->PolicyReference) ? $this->PolicyReference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPolicyReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicyReference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePolicyReferenceForChoiceConstraintsFromSetPolicyReference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Policy',
            'All',
            'ExactlyOne',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PolicyReference can\'t be set as the property %s is already set. Only one property must be set among these properties: PolicyReference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PolicyReference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyReference $policyReference
     * @return \StructType\OperatorContentType
     */
    public function setPolicyReference(\StructType\PolicyReference $policyReference = null)
    {
        // validation for constraint: choice(Policy, All, ExactlyOne, PolicyReference, )
        if ('' !== ($policyReferenceChoiceErrorMessage = self::validatePolicyReferenceForChoiceConstraintsFromSetPolicyReference($policyReference))) {
            throw new \InvalidArgumentException($policyReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($policyReference) || (is_array($policyReference) && empty($policyReference))) {
            unset($this->PolicyReference);
        } else {
            $this->PolicyReference = $policyReference;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\OperatorContentType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
