<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsgTimeStampsType StructType
 * @subpackage Structs
 */
class MsgTimeStampsType extends AbstractStructBase
{
    /**
     * The ObsoleteAfter
     * Meta information extracted from the WSDL
     * - documentation: Date, when this message is obsolete; may be set by Initiator
     * - minOccurs: 0
     * @var string
     */
    public $ObsoleteAfter;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - documentation: Time of entry in a Recipient MsgBox
     * - minOccurs: 0
     * @var string
     */
    public $Delivery;
    /**
     * The InitialFetch
     * Meta information extracted from the WSDL
     * - documentation: Time of first comitted fetch from MsgBox by the Recipient
     * - minOccurs: 0
     * @var string
     */
    public $InitialFetch;
    /**
     * The Reception
     * Meta information extracted from the WSDL
     * - documentation: Reception Time set by the Recipient
     * - minOccurs: 0
     * @var string
     */
    public $Reception;
    /**
     * Constructor method for MsgTimeStampsType
     * @uses MsgTimeStampsType::setObsoleteAfter()
     * @uses MsgTimeStampsType::setDelivery()
     * @uses MsgTimeStampsType::setInitialFetch()
     * @uses MsgTimeStampsType::setReception()
     * @param string $obsoleteAfter
     * @param string $delivery
     * @param string $initialFetch
     * @param string $reception
     */
    public function __construct($obsoleteAfter = null, $delivery = null, $initialFetch = null, $reception = null)
    {
        $this
            ->setObsoleteAfter($obsoleteAfter)
            ->setDelivery($delivery)
            ->setInitialFetch($initialFetch)
            ->setReception($reception);
    }
    /**
     * Get ObsoleteAfter value
     * @return string|null
     */
    public function getObsoleteAfter()
    {
        return $this->ObsoleteAfter;
    }
    /**
     * Set ObsoleteAfter value
     * @param string $obsoleteAfter
     * @return \StructType\MsgTimeStampsType
     */
    public function setObsoleteAfter($obsoleteAfter = null)
    {
        // validation for constraint: string
        if (!is_null($obsoleteAfter) && !is_string($obsoleteAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obsoleteAfter, true), gettype($obsoleteAfter)), __LINE__);
        }
        $this->ObsoleteAfter = $obsoleteAfter;
        return $this;
    }
    /**
     * Get Delivery value
     * @return string|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param string $delivery
     * @return \StructType\MsgTimeStampsType
     */
    public function setDelivery($delivery = null)
    {
        // validation for constraint: string
        if (!is_null($delivery) && !is_string($delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivery, true), gettype($delivery)), __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get InitialFetch value
     * @return string|null
     */
    public function getInitialFetch()
    {
        return $this->InitialFetch;
    }
    /**
     * Set InitialFetch value
     * @param string $initialFetch
     * @return \StructType\MsgTimeStampsType
     */
    public function setInitialFetch($initialFetch = null)
    {
        // validation for constraint: string
        if (!is_null($initialFetch) && !is_string($initialFetch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialFetch, true), gettype($initialFetch)), __LINE__);
        }
        $this->InitialFetch = $initialFetch;
        return $this;
    }
    /**
     * Get Reception value
     * @return string|null
     */
    public function getReception()
    {
        return $this->Reception;
    }
    /**
     * Set Reception value
     * @param string $reception
     * @return \StructType\MsgTimeStampsType
     */
    public function setReception($reception = null)
    {
        // validation for constraint: string
        if (!is_null($reception) && !is_string($reception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reception, true), gettype($reception)), __LINE__);
        }
        $this->Reception = $reception;
        return $this;
    }
}
