<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsgStatusListType StructType
 * @subpackage Structs
 */
class MsgStatusListType extends AbstractStructBase
{
    /**
     * The MsgAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MsgAttributeListType[]
     */
    public $MsgAttributes;
    /**
     * The MessageMetaData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: oscimeta:MessageMetaData
     * @var \StructType\MessageMetaData[]
     */
    public $MessageMetaData;
    /**
     * Constructor method for MsgStatusListType
     * @uses MsgStatusListType::setMsgAttributes()
     * @uses MsgStatusListType::setMessageMetaData()
     * @param \StructType\MsgAttributeListType[] $msgAttributes
     * @param \StructType\MessageMetaData[] $messageMetaData
     */
    public function __construct(array $msgAttributes = array(), array $messageMetaData = array())
    {
        $this
            ->setMsgAttributes($msgAttributes)
            ->setMessageMetaData($messageMetaData);
    }
    /**
     * Get MsgAttributes value
     * @return \StructType\MsgAttributeListType[]|null
     */
    public function getMsgAttributes()
    {
        return $this->MsgAttributes;
    }
    /**
     * This method is responsible for validating the values passed to the setMsgAttributes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMsgAttributes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMsgAttributesForArrayConstraintsFromSetMsgAttributes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $msgStatusListTypeMsgAttributesItem) {
            // validation for constraint: itemType
            if (!$msgStatusListTypeMsgAttributesItem instanceof \StructType\MsgAttributeListType) {
                $invalidValues[] = is_object($msgStatusListTypeMsgAttributesItem) ? get_class($msgStatusListTypeMsgAttributesItem) : sprintf('%s(%s)', gettype($msgStatusListTypeMsgAttributesItem), var_export($msgStatusListTypeMsgAttributesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MsgAttributes property can only contain items of type \StructType\MsgAttributeListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MsgAttributes value
     * @throws \InvalidArgumentException
     * @param \StructType\MsgAttributeListType[] $msgAttributes
     * @return \StructType\MsgStatusListType
     */
    public function setMsgAttributes(array $msgAttributes = array())
    {
        // validation for constraint: array
        if ('' !== ($msgAttributesArrayErrorMessage = self::validateMsgAttributesForArrayConstraintsFromSetMsgAttributes($msgAttributes))) {
            throw new \InvalidArgumentException($msgAttributesArrayErrorMessage, __LINE__);
        }
        $this->MsgAttributes = $msgAttributes;
        return $this;
    }
    /**
     * Add item to MsgAttributes value
     * @throws \InvalidArgumentException
     * @param \StructType\MsgAttributeListType $item
     * @return \StructType\MsgStatusListType
     */
    public function addToMsgAttributes(\StructType\MsgAttributeListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MsgAttributeListType) {
            throw new \InvalidArgumentException(sprintf('The MsgAttributes property can only contain items of type \StructType\MsgAttributeListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MsgAttributes[] = $item;
        return $this;
    }
    /**
     * Get MessageMetaData value
     * @return \StructType\MessageMetaData[]|null
     */
    public function getMessageMetaData()
    {
        return $this->MessageMetaData;
    }
    /**
     * This method is responsible for validating the values passed to the setMessageMetaData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessageMetaData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageMetaDataForArrayConstraintsFromSetMessageMetaData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $msgStatusListTypeMessageMetaDataItem) {
            // validation for constraint: itemType
            if (!$msgStatusListTypeMessageMetaDataItem instanceof \StructType\MessageMetaData) {
                $invalidValues[] = is_object($msgStatusListTypeMessageMetaDataItem) ? get_class($msgStatusListTypeMessageMetaDataItem) : sprintf('%s(%s)', gettype($msgStatusListTypeMessageMetaDataItem), var_export($msgStatusListTypeMessageMetaDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MessageMetaData property can only contain items of type \StructType\MessageMetaData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MessageMetaData value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageMetaData[] $messageMetaData
     * @return \StructType\MsgStatusListType
     */
    public function setMessageMetaData(array $messageMetaData = array())
    {
        // validation for constraint: array
        if ('' !== ($messageMetaDataArrayErrorMessage = self::validateMessageMetaDataForArrayConstraintsFromSetMessageMetaData($messageMetaData))) {
            throw new \InvalidArgumentException($messageMetaDataArrayErrorMessage, __LINE__);
        }
        $this->MessageMetaData = $messageMetaData;
        return $this;
    }
    /**
     * Add item to MessageMetaData value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageMetaData $item
     * @return \StructType\MsgStatusListType
     */
    public function addToMessageMetaData(\StructType\MessageMetaData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MessageMetaData) {
            throw new \InvalidArgumentException(sprintf('The MessageMetaData property can only contain items of type \StructType\MessageMetaData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MessageMetaData[] = $item;
        return $this;
    }
}
