<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsgSelector StructType
 * @subpackage Structs
 */
class MsgSelector extends AbstractStructBase
{
    /**
     * The MessageID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: wsa:MessageID
     * @var \StructType\AttributedURIType[]
     */
    public $MessageID;
    /**
     * The RelatesTo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: wsa:RelatesTo
     * @var \StructType\RelatesToType[]
     */
    public $RelatesTo;
    /**
     * The MsgBoxEntryTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MsgBoxEntryTimeFrom;
    /**
     * The MsgBoxEntryTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MsgBoxEntryTimeTo;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Extension;
    /**
     * The newEntry
     * @var bool
     */
    public $newEntry;
    /**
     * Constructor method for MsgSelector
     * @uses MsgSelector::setMessageID()
     * @uses MsgSelector::setRelatesTo()
     * @uses MsgSelector::setMsgBoxEntryTimeFrom()
     * @uses MsgSelector::setMsgBoxEntryTimeTo()
     * @uses MsgSelector::setExtension()
     * @uses MsgSelector::setNewEntry()
     * @param \StructType\AttributedURIType[] $messageID
     * @param \StructType\RelatesToType[] $relatesTo
     * @param string $msgBoxEntryTimeFrom
     * @param string $msgBoxEntryTimeTo
     * @param mixed $extension
     * @param bool $newEntry
     */
    public function __construct(array $messageID = array(), array $relatesTo = array(), $msgBoxEntryTimeFrom = null, $msgBoxEntryTimeTo = null, $extension = null, $newEntry = null)
    {
        $this
            ->setMessageID($messageID)
            ->setRelatesTo($relatesTo)
            ->setMsgBoxEntryTimeFrom($msgBoxEntryTimeFrom)
            ->setMsgBoxEntryTimeTo($msgBoxEntryTimeTo)
            ->setExtension($extension)
            ->setNewEntry($newEntry);
    }
    /**
     * Get MessageID value
     * @return \StructType\AttributedURIType[]|null
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * This method is responsible for validating the values passed to the setMessageID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessageID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageIDForArrayConstraintsFromSetMessageID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $msgSelectorMessageIDItem) {
            // validation for constraint: itemType
            if (!$msgSelectorMessageIDItem instanceof \StructType\AttributedURIType) {
                $invalidValues[] = is_object($msgSelectorMessageIDItem) ? get_class($msgSelectorMessageIDItem) : sprintf('%s(%s)', gettype($msgSelectorMessageIDItem), var_export($msgSelectorMessageIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MessageID property can only contain items of type \StructType\AttributedURIType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MessageID value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedURIType[] $messageID
     * @return \StructType\MsgSelector
     */
    public function setMessageID(array $messageID = array())
    {
        // validation for constraint: array
        if ('' !== ($messageIDArrayErrorMessage = self::validateMessageIDForArrayConstraintsFromSetMessageID($messageID))) {
            throw new \InvalidArgumentException($messageIDArrayErrorMessage, __LINE__);
        }
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Add item to MessageID value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedURIType $item
     * @return \StructType\MsgSelector
     */
    public function addToMessageID(\StructType\AttributedURIType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributedURIType) {
            throw new \InvalidArgumentException(sprintf('The MessageID property can only contain items of type \StructType\AttributedURIType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MessageID[] = $item;
        return $this;
    }
    /**
     * Get RelatesTo value
     * @return \StructType\RelatesToType[]|null
     */
    public function getRelatesTo()
    {
        return $this->RelatesTo;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatesTo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatesTo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatesToForArrayConstraintsFromSetRelatesTo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $msgSelectorRelatesToItem) {
            // validation for constraint: itemType
            if (!$msgSelectorRelatesToItem instanceof \StructType\RelatesToType) {
                $invalidValues[] = is_object($msgSelectorRelatesToItem) ? get_class($msgSelectorRelatesToItem) : sprintf('%s(%s)', gettype($msgSelectorRelatesToItem), var_export($msgSelectorRelatesToItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatesTo property can only contain items of type \StructType\RelatesToType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatesTo value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatesToType[] $relatesTo
     * @return \StructType\MsgSelector
     */
    public function setRelatesTo(array $relatesTo = array())
    {
        // validation for constraint: array
        if ('' !== ($relatesToArrayErrorMessage = self::validateRelatesToForArrayConstraintsFromSetRelatesTo($relatesTo))) {
            throw new \InvalidArgumentException($relatesToArrayErrorMessage, __LINE__);
        }
        $this->RelatesTo = $relatesTo;
        return $this;
    }
    /**
     * Add item to RelatesTo value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatesToType $item
     * @return \StructType\MsgSelector
     */
    public function addToRelatesTo(\StructType\RelatesToType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatesToType) {
            throw new \InvalidArgumentException(sprintf('The RelatesTo property can only contain items of type \StructType\RelatesToType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatesTo[] = $item;
        return $this;
    }
    /**
     * Get MsgBoxEntryTimeFrom value
     * @return string|null
     */
    public function getMsgBoxEntryTimeFrom()
    {
        return $this->MsgBoxEntryTimeFrom;
    }
    /**
     * Set MsgBoxEntryTimeFrom value
     * @param string $msgBoxEntryTimeFrom
     * @return \StructType\MsgSelector
     */
    public function setMsgBoxEntryTimeFrom($msgBoxEntryTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($msgBoxEntryTimeFrom) && !is_string($msgBoxEntryTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msgBoxEntryTimeFrom, true), gettype($msgBoxEntryTimeFrom)), __LINE__);
        }
        $this->MsgBoxEntryTimeFrom = $msgBoxEntryTimeFrom;
        return $this;
    }
    /**
     * Get MsgBoxEntryTimeTo value
     * @return string|null
     */
    public function getMsgBoxEntryTimeTo()
    {
        return $this->MsgBoxEntryTimeTo;
    }
    /**
     * Set MsgBoxEntryTimeTo value
     * @param string $msgBoxEntryTimeTo
     * @return \StructType\MsgSelector
     */
    public function setMsgBoxEntryTimeTo($msgBoxEntryTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($msgBoxEntryTimeTo) && !is_string($msgBoxEntryTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msgBoxEntryTimeTo, true), gettype($msgBoxEntryTimeTo)), __LINE__);
        }
        $this->MsgBoxEntryTimeTo = $msgBoxEntryTimeTo;
        return $this;
    }
    /**
     * Get Extension value
     * @return mixed|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param mixed $extension
     * @return \StructType\MsgSelector
     */
    public function setExtension($extension = null)
    {
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Get newEntry value
     * @return bool|null
     */
    public function getNewEntry()
    {
        return $this->newEntry;
    }
    /**
     * Set newEntry value
     * @param bool $newEntry
     * @return \StructType\MsgSelector
     */
    public function setNewEntry($newEntry = null)
    {
        // validation for constraint: boolean
        if (!is_null($newEntry) && !is_bool($newEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newEntry, true), gettype($newEntry)), __LINE__);
        }
        $this->newEntry = $newEntry;
        return $this;
    }
}
