<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsgIdentificationType StructType
 * @subpackage Structs
 */
class MsgIdentificationType extends AbstractStructBase
{
    /**
     * The MessageID
     * Meta information extracted from the WSDL
     * - ref: wsa:MessageID
     * @var \StructType\AttributedURIType
     */
    public $MessageID;
    /**
     * The In_Reply_To
     * Meta information extracted from the WSDL
     * - documentation: Referenced application level Message-Id(s)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttributedURIType[]
     */
    public $In_Reply_To;
    /**
     * The ProcessRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProcessRef
     */
    public $ProcessRef;
    /**
     * Constructor method for MsgIdentificationType
     * @uses MsgIdentificationType::setMessageID()
     * @uses MsgIdentificationType::setIn_Reply_To()
     * @uses MsgIdentificationType::setProcessRef()
     * @param \StructType\AttributedURIType $messageID
     * @param \StructType\AttributedURIType[] $in_Reply_To
     * @param \StructType\ProcessRef $processRef
     */
    public function __construct(\StructType\AttributedURIType $messageID = null, array $in_Reply_To = array(), \StructType\ProcessRef $processRef = null)
    {
        $this
            ->setMessageID($messageID)
            ->setIn_Reply_To($in_Reply_To)
            ->setProcessRef($processRef);
    }
    /**
     * Get MessageID value
     * @return \StructType\AttributedURIType|null
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param \StructType\AttributedURIType $messageID
     * @return \StructType\MsgIdentificationType
     */
    public function setMessageID(\StructType\AttributedURIType $messageID = null)
    {
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get In_Reply_To value
     * @return \StructType\AttributedURIType[]|null
     */
    public function getIn_Reply_To()
    {
        return $this->{'In-Reply-To'};
    }
    /**
     * This method is responsible for validating the values passed to the setIn_Reply_To method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIn_Reply_To method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIn_Reply_ToForArrayConstraintsFromSetIn_Reply_To(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $msgIdentificationTypeIn_Reply_ToItem) {
            // validation for constraint: itemType
            if (!$msgIdentificationTypeIn_Reply_ToItem instanceof \StructType\AttributedURIType) {
                $invalidValues[] = is_object($msgIdentificationTypeIn_Reply_ToItem) ? get_class($msgIdentificationTypeIn_Reply_ToItem) : sprintf('%s(%s)', gettype($msgIdentificationTypeIn_Reply_ToItem), var_export($msgIdentificationTypeIn_Reply_ToItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The In_Reply_To property can only contain items of type \StructType\AttributedURIType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set In_Reply_To value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedURIType[] $in_Reply_To
     * @return \StructType\MsgIdentificationType
     */
    public function setIn_Reply_To(array $in_Reply_To = array())
    {
        // validation for constraint: array
        if ('' !== ($in_Reply_ToArrayErrorMessage = self::validateIn_Reply_ToForArrayConstraintsFromSetIn_Reply_To($in_Reply_To))) {
            throw new \InvalidArgumentException($in_Reply_ToArrayErrorMessage, __LINE__);
        }
        $this->In_Reply_To = $this->{'In-Reply-To'} = $in_Reply_To;
        return $this;
    }
    /**
     * Add item to In_Reply_To value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedURIType $item
     * @return \StructType\MsgIdentificationType
     */
    public function addToIn_Reply_To(\StructType\AttributedURIType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributedURIType) {
            throw new \InvalidArgumentException(sprintf('The In_Reply_To property can only contain items of type \StructType\AttributedURIType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->In_Reply_To[] = $this->{'In-Reply-To'}[] = $item;
        return $this;
    }
    /**
     * Get ProcessRef value
     * @return \StructType\ProcessRef|null
     */
    public function getProcessRef()
    {
        return $this->ProcessRef;
    }
    /**
     * Set ProcessRef value
     * @param \StructType\ProcessRef $processRef
     * @return \StructType\MsgIdentificationType
     */
    public function setProcessRef(\StructType\ProcessRef $processRef = null)
    {
        $this->ProcessRef = $processRef;
        return $this;
    }
}
