<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsgBoxResponseType StructType
 * @subpackage Structs
 */
class MsgBoxResponseType extends AbstractStructBase
{
    /**
     * The MsgBoxRequestID
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $MsgBoxRequestID;
    /**
     * The NoMessageAvailable
     * Meta information extracted from the WSDL
     * - choice: NoMessageAvailable | ItemsPending
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\NoMessageAvailable
     */
    public $NoMessageAvailable;
    /**
     * The ItemsPending
     * Meta information extracted from the WSDL
     * - choice: NoMessageAvailable | ItemsPending
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $ItemsPending;
    /**
     * Constructor method for MsgBoxResponseType
     * @uses MsgBoxResponseType::setMsgBoxRequestID()
     * @uses MsgBoxResponseType::setNoMessageAvailable()
     * @uses MsgBoxResponseType::setItemsPending()
     * @param string $msgBoxRequestID
     * @param \StructType\NoMessageAvailable $noMessageAvailable
     * @param int $itemsPending
     */
    public function __construct($msgBoxRequestID = null, \StructType\NoMessageAvailable $noMessageAvailable = null, $itemsPending = null)
    {
        $this
            ->setMsgBoxRequestID($msgBoxRequestID)
            ->setNoMessageAvailable($noMessageAvailable)
            ->setItemsPending($itemsPending);
    }
    /**
     * Get MsgBoxRequestID value
     * @return string
     */
    public function getMsgBoxRequestID()
    {
        return $this->MsgBoxRequestID;
    }
    /**
     * Set MsgBoxRequestID value
     * @param string $msgBoxRequestID
     * @return \StructType\MsgBoxResponseType
     */
    public function setMsgBoxRequestID($msgBoxRequestID = null)
    {
        // validation for constraint: string
        if (!is_null($msgBoxRequestID) && !is_string($msgBoxRequestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msgBoxRequestID, true), gettype($msgBoxRequestID)), __LINE__);
        }
        $this->MsgBoxRequestID = $msgBoxRequestID;
        return $this;
    }
    /**
     * Get NoMessageAvailable value
     * @return \StructType\NoMessageAvailable|null
     */
    public function getNoMessageAvailable()
    {
        return isset($this->NoMessageAvailable) ? $this->NoMessageAvailable : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNoMessageAvailable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNoMessageAvailable method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNoMessageAvailableForChoiceConstraintsFromSetNoMessageAvailable($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ItemsPending',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NoMessageAvailable can\'t be set as the property %s is already set. Only one property must be set among these properties: NoMessageAvailable, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NoMessageAvailable value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NoMessageAvailable $noMessageAvailable
     * @return \StructType\MsgBoxResponseType
     */
    public function setNoMessageAvailable(\StructType\NoMessageAvailable $noMessageAvailable = null)
    {
        // validation for constraint: choice(NoMessageAvailable, ItemsPending)
        if ('' !== ($noMessageAvailableChoiceErrorMessage = self::validateNoMessageAvailableForChoiceConstraintsFromSetNoMessageAvailable($noMessageAvailable))) {
            throw new \InvalidArgumentException($noMessageAvailableChoiceErrorMessage, __LINE__);
        }
        if (is_null($noMessageAvailable) || (is_array($noMessageAvailable) && empty($noMessageAvailable))) {
            unset($this->NoMessageAvailable);
        } else {
            $this->NoMessageAvailable = $noMessageAvailable;
        }
        return $this;
    }
    /**
     * Get ItemsPending value
     * @return int|null
     */
    public function getItemsPending()
    {
        return isset($this->ItemsPending) ? $this->ItemsPending : null;
    }
    /**
     * This method is responsible for validating the value passed to the setItemsPending method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemsPending method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemsPendingForChoiceConstraintsFromSetItemsPending($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NoMessageAvailable',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ItemsPending can\'t be set as the property %s is already set. Only one property must be set among these properties: ItemsPending, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ItemsPending value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $itemsPending
     * @return \StructType\MsgBoxResponseType
     */
    public function setItemsPending($itemsPending = null)
    {
        // validation for constraint: int
        if (!is_null($itemsPending) && !(is_int($itemsPending) || ctype_digit($itemsPending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemsPending, true), gettype($itemsPending)), __LINE__);
        }
        // validation for constraint: choice(NoMessageAvailable, ItemsPending)
        if ('' !== ($itemsPendingChoiceErrorMessage = self::validateItemsPendingForChoiceConstraintsFromSetItemsPending($itemsPending))) {
            throw new \InvalidArgumentException($itemsPendingChoiceErrorMessage, __LINE__);
        }
        if (is_null($itemsPending) || (is_array($itemsPending) && empty($itemsPending))) {
            unset($this->ItemsPending);
        } else {
            $this->ItemsPending = $itemsPending;
        }
        return $this;
    }
}
