<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsgBoxGetNextRequestType StructType
 * @subpackage Structs
 */
class MsgBoxGetNextRequestType extends AbstractStructBase
{
    /**
     * The MsgBoxRequestID
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $MsgBoxRequestID;
    /**
     * The LastMsgReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AttributedURIType[]
     */
    public $LastMsgReceived;
    /**
     * Constructor method for MsgBoxGetNextRequestType
     * @uses MsgBoxGetNextRequestType::setMsgBoxRequestID()
     * @uses MsgBoxGetNextRequestType::setLastMsgReceived()
     * @param string $msgBoxRequestID
     * @param \StructType\AttributedURIType[] $lastMsgReceived
     */
    public function __construct($msgBoxRequestID = null, array $lastMsgReceived = array())
    {
        $this
            ->setMsgBoxRequestID($msgBoxRequestID)
            ->setLastMsgReceived($lastMsgReceived);
    }
    /**
     * Get MsgBoxRequestID value
     * @return string
     */
    public function getMsgBoxRequestID()
    {
        return $this->MsgBoxRequestID;
    }
    /**
     * Set MsgBoxRequestID value
     * @param string $msgBoxRequestID
     * @return \StructType\MsgBoxGetNextRequestType
     */
    public function setMsgBoxRequestID($msgBoxRequestID = null)
    {
        // validation for constraint: string
        if (!is_null($msgBoxRequestID) && !is_string($msgBoxRequestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msgBoxRequestID, true), gettype($msgBoxRequestID)), __LINE__);
        }
        $this->MsgBoxRequestID = $msgBoxRequestID;
        return $this;
    }
    /**
     * Get LastMsgReceived value
     * @return \StructType\AttributedURIType[]|null
     */
    public function getLastMsgReceived()
    {
        return $this->LastMsgReceived;
    }
    /**
     * This method is responsible for validating the values passed to the setLastMsgReceived method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastMsgReceived method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastMsgReceivedForArrayConstraintsFromSetLastMsgReceived(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $msgBoxGetNextRequestTypeLastMsgReceivedItem) {
            // validation for constraint: itemType
            if (!$msgBoxGetNextRequestTypeLastMsgReceivedItem instanceof \StructType\AttributedURIType) {
                $invalidValues[] = is_object($msgBoxGetNextRequestTypeLastMsgReceivedItem) ? get_class($msgBoxGetNextRequestTypeLastMsgReceivedItem) : sprintf('%s(%s)', gettype($msgBoxGetNextRequestTypeLastMsgReceivedItem), var_export($msgBoxGetNextRequestTypeLastMsgReceivedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LastMsgReceived property can only contain items of type \StructType\AttributedURIType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LastMsgReceived value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedURIType[] $lastMsgReceived
     * @return \StructType\MsgBoxGetNextRequestType
     */
    public function setLastMsgReceived(array $lastMsgReceived = array())
    {
        // validation for constraint: array
        if ('' !== ($lastMsgReceivedArrayErrorMessage = self::validateLastMsgReceivedForArrayConstraintsFromSetLastMsgReceived($lastMsgReceived))) {
            throw new \InvalidArgumentException($lastMsgReceivedArrayErrorMessage, __LINE__);
        }
        $this->LastMsgReceived = $lastMsgReceived;
        return $this;
    }
    /**
     * Add item to LastMsgReceived value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedURIType $item
     * @return \StructType\MsgBoxGetNextRequestType
     */
    public function addToLastMsgReceived(\StructType\AttributedURIType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributedURIType) {
            throw new \InvalidArgumentException(sprintf('The LastMsgReceived property can only contain items of type \StructType\AttributedURIType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LastMsgReceived[] = $item;
        return $this;
    }
}
