<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsgAttributeListType StructType
 * @subpackage Structs
 */
class MsgAttributeListType extends AbstractStructBase
{
    /**
     * The MessageID
     * Meta information extracted from the WSDL
     * - ref: wsa:MessageID
     * @var \StructType\AttributedURIType
     */
    public $MessageID;
    /**
     * The RelatesTo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: wsa:RelatesTo
     * @var \StructType\RelatesToType[]
     */
    public $RelatesTo;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: wsa:From
     * @var \StructType\EndpointReferenceType
     */
    public $From;
    /**
     * The TypeOfBusinessScenario
     * Meta information extracted from the WSDL
     * - ref: osci:TypeOfBusinessScenario
     * @var \StructType\TypeOfBusinessScenarioType
     */
    public $TypeOfBusinessScenario;
    /**
     * The MsgSize
     * @var int
     */
    public $MsgSize;
    /**
     * The ObsoleteAfterDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ObsoleteAfterDate;
    /**
     * The DeliveryTime
     * @var string
     */
    public $DeliveryTime;
    /**
     * The InitialFetchedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InitialFetchedTime;
    /**
     * Constructor method for MsgAttributeListType
     * @uses MsgAttributeListType::setMessageID()
     * @uses MsgAttributeListType::setRelatesTo()
     * @uses MsgAttributeListType::setFrom()
     * @uses MsgAttributeListType::setTypeOfBusinessScenario()
     * @uses MsgAttributeListType::setMsgSize()
     * @uses MsgAttributeListType::setObsoleteAfterDate()
     * @uses MsgAttributeListType::setDeliveryTime()
     * @uses MsgAttributeListType::setInitialFetchedTime()
     * @param \StructType\AttributedURIType $messageID
     * @param \StructType\RelatesToType[] $relatesTo
     * @param \StructType\EndpointReferenceType $from
     * @param \StructType\TypeOfBusinessScenarioType $typeOfBusinessScenario
     * @param int $msgSize
     * @param string $obsoleteAfterDate
     * @param string $deliveryTime
     * @param string $initialFetchedTime
     */
    public function __construct(\StructType\AttributedURIType $messageID = null, array $relatesTo = array(), \StructType\EndpointReferenceType $from = null, \StructType\TypeOfBusinessScenarioType $typeOfBusinessScenario = null, $msgSize = null, $obsoleteAfterDate = null, $deliveryTime = null, $initialFetchedTime = null)
    {
        $this
            ->setMessageID($messageID)
            ->setRelatesTo($relatesTo)
            ->setFrom($from)
            ->setTypeOfBusinessScenario($typeOfBusinessScenario)
            ->setMsgSize($msgSize)
            ->setObsoleteAfterDate($obsoleteAfterDate)
            ->setDeliveryTime($deliveryTime)
            ->setInitialFetchedTime($initialFetchedTime);
    }
    /**
     * Get MessageID value
     * @return \StructType\AttributedURIType|null
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param \StructType\AttributedURIType $messageID
     * @return \StructType\MsgAttributeListType
     */
    public function setMessageID(\StructType\AttributedURIType $messageID = null)
    {
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get RelatesTo value
     * @return \StructType\RelatesToType[]|null
     */
    public function getRelatesTo()
    {
        return $this->RelatesTo;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatesTo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatesTo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatesToForArrayConstraintsFromSetRelatesTo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $msgAttributeListTypeRelatesToItem) {
            // validation for constraint: itemType
            if (!$msgAttributeListTypeRelatesToItem instanceof \StructType\RelatesToType) {
                $invalidValues[] = is_object($msgAttributeListTypeRelatesToItem) ? get_class($msgAttributeListTypeRelatesToItem) : sprintf('%s(%s)', gettype($msgAttributeListTypeRelatesToItem), var_export($msgAttributeListTypeRelatesToItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatesTo property can only contain items of type \StructType\RelatesToType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatesTo value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatesToType[] $relatesTo
     * @return \StructType\MsgAttributeListType
     */
    public function setRelatesTo(array $relatesTo = array())
    {
        // validation for constraint: array
        if ('' !== ($relatesToArrayErrorMessage = self::validateRelatesToForArrayConstraintsFromSetRelatesTo($relatesTo))) {
            throw new \InvalidArgumentException($relatesToArrayErrorMessage, __LINE__);
        }
        $this->RelatesTo = $relatesTo;
        return $this;
    }
    /**
     * Add item to RelatesTo value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatesToType $item
     * @return \StructType\MsgAttributeListType
     */
    public function addToRelatesTo(\StructType\RelatesToType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatesToType) {
            throw new \InvalidArgumentException(sprintf('The RelatesTo property can only contain items of type \StructType\RelatesToType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatesTo[] = $item;
        return $this;
    }
    /**
     * Get From value
     * @return \StructType\EndpointReferenceType|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param \StructType\EndpointReferenceType $from
     * @return \StructType\MsgAttributeListType
     */
    public function setFrom(\StructType\EndpointReferenceType $from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get TypeOfBusinessScenario value
     * @return \StructType\TypeOfBusinessScenarioType|null
     */
    public function getTypeOfBusinessScenario()
    {
        return $this->TypeOfBusinessScenario;
    }
    /**
     * Set TypeOfBusinessScenario value
     * @param \StructType\TypeOfBusinessScenarioType $typeOfBusinessScenario
     * @return \StructType\MsgAttributeListType
     */
    public function setTypeOfBusinessScenario(\StructType\TypeOfBusinessScenarioType $typeOfBusinessScenario = null)
    {
        $this->TypeOfBusinessScenario = $typeOfBusinessScenario;
        return $this;
    }
    /**
     * Get MsgSize value
     * @return int|null
     */
    public function getMsgSize()
    {
        return $this->MsgSize;
    }
    /**
     * Set MsgSize value
     * @param int $msgSize
     * @return \StructType\MsgAttributeListType
     */
    public function setMsgSize($msgSize = null)
    {
        // validation for constraint: int
        if (!is_null($msgSize) && !(is_int($msgSize) || ctype_digit($msgSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($msgSize, true), gettype($msgSize)), __LINE__);
        }
        $this->MsgSize = $msgSize;
        return $this;
    }
    /**
     * Get ObsoleteAfterDate value
     * @return string|null
     */
    public function getObsoleteAfterDate()
    {
        return $this->ObsoleteAfterDate;
    }
    /**
     * Set ObsoleteAfterDate value
     * @param string $obsoleteAfterDate
     * @return \StructType\MsgAttributeListType
     */
    public function setObsoleteAfterDate($obsoleteAfterDate = null)
    {
        // validation for constraint: string
        if (!is_null($obsoleteAfterDate) && !is_string($obsoleteAfterDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obsoleteAfterDate, true), gettype($obsoleteAfterDate)), __LINE__);
        }
        $this->ObsoleteAfterDate = $obsoleteAfterDate;
        return $this;
    }
    /**
     * Get DeliveryTime value
     * @return string|null
     */
    public function getDeliveryTime()
    {
        return $this->DeliveryTime;
    }
    /**
     * Set DeliveryTime value
     * @param string $deliveryTime
     * @return \StructType\MsgAttributeListType
     */
    public function setDeliveryTime($deliveryTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTime) && !is_string($deliveryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTime, true), gettype($deliveryTime)), __LINE__);
        }
        $this->DeliveryTime = $deliveryTime;
        return $this;
    }
    /**
     * Get InitialFetchedTime value
     * @return string|null
     */
    public function getInitialFetchedTime()
    {
        return $this->InitialFetchedTime;
    }
    /**
     * Set InitialFetchedTime value
     * @param string $initialFetchedTime
     * @return \StructType\MsgAttributeListType
     */
    public function setInitialFetchedTime($initialFetchedTime = null)
    {
        // validation for constraint: string
        if (!is_null($initialFetchedTime) && !is_string($initialFetchedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialFetchedTime, true), gettype($initialFetchedTime)), __LINE__);
        }
        $this->InitialFetchedTime = $initialFetchedTime;
        return $this;
    }
}
