<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Dies ist die fachliche Identifizierung des Lesers. Der Wert entspricht z.B. dem DVDV-Behördenschlüssel. | Dies ist die Struktur einer Service-Anfrage: Sie enthält die Daten über den Diensteanbieter (Leser) und den Dienst des
 * Lesers, den der Autor in Anspruch nehmen will. Diese Anfrage dient dazu, zu ermitteln, ob der Dienst von diesem Anbieter angeboten wird und über welche technischen Parameter er angesprochen werden kann.
 * @subpackage Structs
 */
class LookupServiceType extends AbstractStructBase
{
    /**
     * The Reader
     * Meta information extracted from the WSDL
     * - ref: oscimeta:Reader
     * @var \StructType\PartyType
     */
    public $Reader;
    /**
     * The ServiceType
     * Meta information extracted from the WSDL
     * - documentation: Dies ist die Bezeichnung des anzufordernden Dienstes. Sie wird im Format einer URL übergeben, was den Vorteil hat, dass damit auch eine Versionsnummer eingeschlossen ist. Beispiel für Dienstebezeichnungen, wie sie im DVDV verwendet
     * werden: http://www.osci.de/xmeld181/xmeld181Rueckmeldung.wsdlAbgrenzung: "Dienst" ist das, was gemäß Diensteeinteilung der Fachdomäne im Verzeichnisdienst als Service (im Sinne eines Web Service) eingetragen ist. Dadurch ist die Dienstebezeichnung
     * weniger differenziert als der Nachrichtentyp. Typischerweise sind im Verzeichnisdienst mehrere Nachrichtentypen in einer Service-WSDL zusammengefasst.
     * @var string
     */
    public $ServiceType;
    /**
     * Constructor method for LookupServiceType
     * @uses LookupServiceType::setReader()
     * @uses LookupServiceType::setServiceType()
     * @param \StructType\PartyType $reader
     * @param string $serviceType
     */
    public function __construct(\StructType\PartyType $reader = null, $serviceType = null)
    {
        $this
            ->setReader($reader)
            ->setServiceType($serviceType);
    }
    /**
     * Get Reader value
     * @return \StructType\PartyType|null
     */
    public function getReader()
    {
        return $this->Reader;
    }
    /**
     * Set Reader value
     * @param \StructType\PartyType $reader
     * @return \StructType\LookupServiceType
     */
    public function setReader(\StructType\PartyType $reader = null)
    {
        $this->Reader = $reader;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \StructType\LookupServiceType
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
}
