<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupServiceResultType StructType
 * Meta information extracted from the WSDL
 * - documentation: Das Ergebnis zu einer Dienstanfrage, das die Information enthält, ob der Dienst angeboten wird. Außerdem sind die nötigen technischen Paramter für die Erreichbarkeit vorhanden.
 * @subpackage Structs
 */
class LookupServiceResultType extends LookupServiceType
{
    /**
     * The IsServiceAvailableValue
     * Meta information extracted from the WSDL
     * - documentation: Enthält das Ergebnis der Dienstanfrage: ob der Dienst angeboten wird oder nicht oder ob diese Information generell nicht bekannt ist.
     * @var \StructType\IsServiceAvailableValueType
     */
    public $IsServiceAvailableValue;
    /**
     * The ServiceParameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceParameter[]
     */
    public $ServiceParameter;
    /**
     * Constructor method for LookupServiceResultType
     * @uses LookupServiceResultType::setIsServiceAvailableValue()
     * @uses LookupServiceResultType::setServiceParameter()
     * @param \StructType\IsServiceAvailableValueType $isServiceAvailableValue
     * @param \StructType\ServiceParameter[] $serviceParameter
     */
    public function __construct(\StructType\IsServiceAvailableValueType $isServiceAvailableValue = null, array $serviceParameter = array())
    {
        $this
            ->setIsServiceAvailableValue($isServiceAvailableValue)
            ->setServiceParameter($serviceParameter);
    }
    /**
     * Get IsServiceAvailableValue value
     * @return \StructType\IsServiceAvailableValueType|null
     */
    public function getIsServiceAvailableValue()
    {
        return $this->IsServiceAvailableValue;
    }
    /**
     * Set IsServiceAvailableValue value
     * @param \StructType\IsServiceAvailableValueType $isServiceAvailableValue
     * @return \StructType\LookupServiceResultType
     */
    public function setIsServiceAvailableValue(\StructType\IsServiceAvailableValueType $isServiceAvailableValue = null)
    {
        $this->IsServiceAvailableValue = $isServiceAvailableValue;
        return $this;
    }
    /**
     * Get ServiceParameter value
     * @return \StructType\ServiceParameter[]|null
     */
    public function getServiceParameter()
    {
        return $this->ServiceParameter;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceParameterForArrayConstraintsFromSetServiceParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lookupServiceResultTypeServiceParameterItem) {
            // validation for constraint: itemType
            if (!$lookupServiceResultTypeServiceParameterItem instanceof \StructType\ServiceParameter) {
                $invalidValues[] = is_object($lookupServiceResultTypeServiceParameterItem) ? get_class($lookupServiceResultTypeServiceParameterItem) : sprintf('%s(%s)', gettype($lookupServiceResultTypeServiceParameterItem), var_export($lookupServiceResultTypeServiceParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceParameter property can only contain items of type \StructType\ServiceParameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceParameter[] $serviceParameter
     * @return \StructType\LookupServiceResultType
     */
    public function setServiceParameter(array $serviceParameter = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceParameterArrayErrorMessage = self::validateServiceParameterForArrayConstraintsFromSetServiceParameter($serviceParameter))) {
            throw new \InvalidArgumentException($serviceParameterArrayErrorMessage, __LINE__);
        }
        $this->ServiceParameter = $serviceParameter;
        return $this;
    }
    /**
     * Add item to ServiceParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceParameter $item
     * @return \StructType\LookupServiceResultType
     */
    public function addToServiceParameter(\StructType\ServiceParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceParameter) {
            throw new \InvalidArgumentException(sprintf('The ServiceParameter property can only contain items of type \StructType\ServiceParameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceParameter[] = $item;
        return $this;
    }
}
