<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupServiceResultList StructType
 * Meta information extracted from the WSDL
 * - documentation: Die Struktur einer Liste von Dienstanfrageergebnissen.
 * @subpackage Structs
 */
class LookupServiceResultList extends AbstractStructBase
{
    /**
     * The LookupServiceResult
     * Meta information extracted from the WSDL
     * - documentation: Dies ist die Struktur der Liste von Ergebnissen zur Liste von Diensteanfragen.
     * - maxOccurs: unbounded
     * - nillable: true
     * @var \StructType\LookupServiceResultType[]
     */
    public $LookupServiceResult;
    /**
     * Constructor method for LookupServiceResultList
     * @uses LookupServiceResultList::setLookupServiceResult()
     * @param \StructType\LookupServiceResultType[] $lookupServiceResult
     */
    public function __construct(array $lookupServiceResult = array())
    {
        $this
            ->setLookupServiceResult($lookupServiceResult);
    }
    /**
     * Get LookupServiceResult value
     * @return \StructType\LookupServiceResultType[]|null
     */
    public function getLookupServiceResult()
    {
        return $this->LookupServiceResult;
    }
    /**
     * This method is responsible for validating the values passed to the setLookupServiceResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLookupServiceResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLookupServiceResultForArrayConstraintsFromSetLookupServiceResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lookupServiceResultListLookupServiceResultItem) {
            // validation for constraint: itemType
            if (!$lookupServiceResultListLookupServiceResultItem instanceof \StructType\LookupServiceResultType) {
                $invalidValues[] = is_object($lookupServiceResultListLookupServiceResultItem) ? get_class($lookupServiceResultListLookupServiceResultItem) : sprintf('%s(%s)', gettype($lookupServiceResultListLookupServiceResultItem), var_export($lookupServiceResultListLookupServiceResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LookupServiceResult property can only contain items of type \StructType\LookupServiceResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LookupServiceResult value
     * @throws \InvalidArgumentException
     * @param \StructType\LookupServiceResultType[] $lookupServiceResult
     * @return \StructType\LookupServiceResultList
     */
    public function setLookupServiceResult(array $lookupServiceResult = array())
    {
        // validation for constraint: array
        if ('' !== ($lookupServiceResultArrayErrorMessage = self::validateLookupServiceResultForArrayConstraintsFromSetLookupServiceResult($lookupServiceResult))) {
            throw new \InvalidArgumentException($lookupServiceResultArrayErrorMessage, __LINE__);
        }
        $this->LookupServiceResult = $lookupServiceResult;
        return $this;
    }
    /**
     * Add item to LookupServiceResult value
     * @throws \InvalidArgumentException
     * @param \StructType\LookupServiceResultType $item
     * @return \StructType\LookupServiceResultList
     */
    public function addToLookupServiceResult(\StructType\LookupServiceResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LookupServiceResultType) {
            throw new \InvalidArgumentException(sprintf('The LookupServiceResult property can only contain items of type \StructType\LookupServiceResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LookupServiceResult[] = $item;
        return $this;
    }
}
