<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyCodeType StructType
 * @subpackage Structs
 */
class KeyCodeType extends AbstractStructBase
{
    /**
     * The listURI
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $listURI;
    /**
     * The listVersionID
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $listVersionID;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - form: unqualified
     * @var string
     */
    public $code;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for KeyCodeType
     * @uses KeyCodeType::setListURI()
     * @uses KeyCodeType::setListVersionID()
     * @uses KeyCodeType::setCode()
     * @uses KeyCodeType::setName()
     * @param string $listURI
     * @param string $listVersionID
     * @param string $code
     * @param string $name
     */
    public function __construct($listURI = null, $listVersionID = null, $code = null, $name = null)
    {
        $this
            ->setListURI($listURI)
            ->setListVersionID($listVersionID)
            ->setCode($code)
            ->setName($name);
    }
    /**
     * Get listURI value
     * @return string
     */
    public function getListURI()
    {
        return $this->listURI;
    }
    /**
     * Set listURI value
     * @param string $listURI
     * @return \StructType\KeyCodeType
     */
    public function setListURI($listURI = null)
    {
        // validation for constraint: string
        if (!is_null($listURI) && !is_string($listURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listURI, true), gettype($listURI)), __LINE__);
        }
        $this->listURI = $listURI;
        return $this;
    }
    /**
     * Get listVersionID value
     * @return string
     */
    public function getListVersionID()
    {
        return $this->listVersionID;
    }
    /**
     * Set listVersionID value
     * @param string $listVersionID
     * @return \StructType\KeyCodeType
     */
    public function setListVersionID($listVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($listVersionID) && !is_string($listVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listVersionID, true), gettype($listVersionID)), __LINE__);
        }
        $this->listVersionID = $listVersionID;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\KeyCodeType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\KeyCodeType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
