<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoList StructType
 * Meta information extracted from the WSDL
 * - documentation: Liste der Informationsmeldungen.
 * @subpackage Structs
 */
class InfoList extends AbstractStructBase
{
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - documentation: Hier wird die Informationsmeldung mit ihren Parametern eingetragen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecordType[]
     */
    public $Info;
    /**
     * Constructor method for InfoList
     * @uses InfoList::setInfo()
     * @param \StructType\RecordType[] $info
     */
    public function __construct(array $info = array())
    {
        $this
            ->setInfo($info);
    }
    /**
     * Get Info value
     * @return \StructType\RecordType[]|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * This method is responsible for validating the values passed to the setInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoForArrayConstraintsFromSetInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $infoListInfoItem) {
            // validation for constraint: itemType
            if (!$infoListInfoItem instanceof \StructType\RecordType) {
                $invalidValues[] = is_object($infoListInfoItem) ? get_class($infoListInfoItem) : sprintf('%s(%s)', gettype($infoListInfoItem), var_export($infoListInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Info property can only contain items of type \StructType\RecordType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Info value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordType[] $info
     * @return \StructType\InfoList
     */
    public function setInfo(array $info = array())
    {
        // validation for constraint: array
        if ('' !== ($infoArrayErrorMessage = self::validateInfoForArrayConstraintsFromSetInfo($info))) {
            throw new \InvalidArgumentException($infoArrayErrorMessage, __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Add item to Info value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordType $item
     * @return \StructType\InfoList
     */
    public function addToInfo(\StructType\RecordType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecordType) {
            throw new \InvalidArgumentException(sprintf('The Info property can only contain items of type \StructType\RecordType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Info[] = $item;
        return $this;
    }
}
