<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for faultcode StructType
 * @subpackage Structs
 */
class Faultcode extends AbstractStructBase
{
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * The Subcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Subcode
     */
    public $Subcode;
    /**
     * Constructor method for faultcode
     * @uses Faultcode::setValue()
     * @uses Faultcode::setSubcode()
     * @param string $value
     * @param \StructType\Subcode $subcode
     */
    public function __construct($value = null, \StructType\Subcode $subcode = null)
    {
        $this
            ->setValue($value)
            ->setSubcode($subcode);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @uses \EnumType\FaultcodeEnum_1::valueIsValid()
     * @uses \EnumType\FaultcodeEnum_1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $value
     * @return \StructType\Faultcode
     */
    public function setValue($value = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FaultcodeEnum_1::valueIsValid($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FaultcodeEnum_1', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\FaultcodeEnum_1::getValidValues())), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Subcode value
     * @return \StructType\Subcode|null
     */
    public function getSubcode()
    {
        return $this->Subcode;
    }
    /**
     * Set Subcode value
     * @param \StructType\Subcode $subcode
     * @return \StructType\Faultcode
     */
    public function setSubcode(\StructType\Subcode $subcode = null)
    {
        $this->Subcode = $subcode;
        return $this;
    }
}
