<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExceptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieser Datentyp legt die grundlegende Struktur einer Exception im Rahmen des XTA Webservice fest. Sie kapselt Information zu Identität und Bedeutung eines aufgetretenen Fehlers.
 * @subpackage Structs
 */
class ExceptionType extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - documentation: In diesem Element werden Fehlernummer und Fehlertext übermittelt, die einen Fehler näher beschreiben (gemäß verlinkter Codeliste). In das Unterelement code ist die Fehlernummer einzutragen, ins Unterelement name die entsprechende
     * textuelle Repräsentation.
     * @var \StructType\Code_Fehlernummer
     */
    public $errorCode;
    /**
     * Constructor method for ExceptionType
     * @uses ExceptionType::setErrorCode()
     * @param \StructType\Code_Fehlernummer $errorCode
     */
    public function __construct(\StructType\Code_Fehlernummer $errorCode = null)
    {
        $this
            ->setErrorCode($errorCode);
    }
    /**
     * Get errorCode value
     * @return \StructType\Code_Fehlernummer|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param \StructType\Code_Fehlernummer $errorCode
     * @return \StructType\ExceptionType
     */
    public function setErrorCode(\StructType\Code_Fehlernummer $errorCode = null)
    {
        $this->errorCode = $errorCode;
        return $this;
    }
}
