<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EncryptedType StructType
 * @subpackage Structs
 */
abstract class EncryptedType extends AbstractStructBase
{
    /**
     * The EncryptionMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EncryptionMethodType
     */
    public $EncryptionMethod;
    /**
     * The KeyInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:KeyInfo
     * @var \StructType\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The CipherData
     * Meta information extracted from the WSDL
     * - ref: xenc:CipherData
     * @var \StructType\CipherDataType
     */
    public $CipherData;
    /**
     * The EncryptionProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xenc:EncryptionProperties
     * @var \StructType\EncryptionPropertiesType
     */
    public $EncryptionProperties;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The MimeType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MimeType;
    /**
     * The Encoding
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Encoding;
    /**
     * Constructor method for EncryptedType
     * @uses EncryptedType::setEncryptionMethod()
     * @uses EncryptedType::setKeyInfo()
     * @uses EncryptedType::setCipherData()
     * @uses EncryptedType::setEncryptionProperties()
     * @uses EncryptedType::setId()
     * @uses EncryptedType::setType()
     * @uses EncryptedType::setMimeType()
     * @uses EncryptedType::setEncoding()
     * @param \StructType\EncryptionMethodType $encryptionMethod
     * @param \StructType\KeyInfoType $keyInfo
     * @param \StructType\CipherDataType $cipherData
     * @param \StructType\EncryptionPropertiesType $encryptionProperties
     * @param string $id
     * @param string $type
     * @param string $mimeType
     * @param string $encoding
     */
    public function __construct(\StructType\EncryptionMethodType $encryptionMethod = null, \StructType\KeyInfoType $keyInfo = null, \StructType\CipherDataType $cipherData = null, \StructType\EncryptionPropertiesType $encryptionProperties = null, $id = null, $type = null, $mimeType = null, $encoding = null)
    {
        $this
            ->setEncryptionMethod($encryptionMethod)
            ->setKeyInfo($keyInfo)
            ->setCipherData($cipherData)
            ->setEncryptionProperties($encryptionProperties)
            ->setId($id)
            ->setType($type)
            ->setMimeType($mimeType)
            ->setEncoding($encoding);
    }
    /**
     * Get EncryptionMethod value
     * @return \StructType\EncryptionMethodType|null
     */
    public function getEncryptionMethod()
    {
        return $this->EncryptionMethod;
    }
    /**
     * Set EncryptionMethod value
     * @param \StructType\EncryptionMethodType $encryptionMethod
     * @return \StructType\EncryptedType
     */
    public function setEncryptionMethod(\StructType\EncryptionMethodType $encryptionMethod = null)
    {
        $this->EncryptionMethod = $encryptionMethod;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \StructType\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \StructType\KeyInfoType $keyInfo
     * @return \StructType\EncryptedType
     */
    public function setKeyInfo(\StructType\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get CipherData value
     * @return \StructType\CipherDataType|null
     */
    public function getCipherData()
    {
        return $this->CipherData;
    }
    /**
     * Set CipherData value
     * @param \StructType\CipherDataType $cipherData
     * @return \StructType\EncryptedType
     */
    public function setCipherData(\StructType\CipherDataType $cipherData = null)
    {
        $this->CipherData = $cipherData;
        return $this;
    }
    /**
     * Get EncryptionProperties value
     * @return \StructType\EncryptionPropertiesType|null
     */
    public function getEncryptionProperties()
    {
        return $this->EncryptionProperties;
    }
    /**
     * Set EncryptionProperties value
     * @param \StructType\EncryptionPropertiesType $encryptionProperties
     * @return \StructType\EncryptedType
     */
    public function setEncryptionProperties(\StructType\EncryptionPropertiesType $encryptionProperties = null)
    {
        $this->EncryptionProperties = $encryptionProperties;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\EncryptedType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\EncryptedType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get MimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->MimeType;
    }
    /**
     * Set MimeType value
     * @param string $mimeType
     * @return \StructType\EncryptedType
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        $this->MimeType = $mimeType;
        return $this;
    }
    /**
     * Get Encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->Encoding;
    }
    /**
     * Set Encoding value
     * @param string $encoding
     * @return \StructType\EncryptedType
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encoding, true), gettype($encoding)), __LINE__);
        }
        $this->Encoding = $encoding;
        return $this;
    }
}
