<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EncryptedKeyType StructType
 * @subpackage Structs
 */
class EncryptedKeyType extends EncryptedType
{
    /**
     * The ReferenceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xenc:ReferenceList
     * @var \StructType\ReferenceList
     */
    public $ReferenceList;
    /**
     * The CarriedKeyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CarriedKeyName;
    /**
     * The Recipient
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Recipient;
    /**
     * Constructor method for EncryptedKeyType
     * @uses EncryptedKeyType::setReferenceList()
     * @uses EncryptedKeyType::setCarriedKeyName()
     * @uses EncryptedKeyType::setRecipient()
     * @param \StructType\ReferenceList $referenceList
     * @param string $carriedKeyName
     * @param string $recipient
     */
    public function __construct(\StructType\ReferenceList $referenceList = null, $carriedKeyName = null, $recipient = null)
    {
        $this
            ->setReferenceList($referenceList)
            ->setCarriedKeyName($carriedKeyName)
            ->setRecipient($recipient);
    }
    /**
     * Get ReferenceList value
     * @return \StructType\ReferenceList|null
     */
    public function getReferenceList()
    {
        return $this->ReferenceList;
    }
    /**
     * Set ReferenceList value
     * @param \StructType\ReferenceList $referenceList
     * @return \StructType\EncryptedKeyType
     */
    public function setReferenceList(\StructType\ReferenceList $referenceList = null)
    {
        $this->ReferenceList = $referenceList;
        return $this;
    }
    /**
     * Get CarriedKeyName value
     * @return string|null
     */
    public function getCarriedKeyName()
    {
        return $this->CarriedKeyName;
    }
    /**
     * Set CarriedKeyName value
     * @param string $carriedKeyName
     * @return \StructType\EncryptedKeyType
     */
    public function setCarriedKeyName($carriedKeyName = null)
    {
        // validation for constraint: string
        if (!is_null($carriedKeyName) && !is_string($carriedKeyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carriedKeyName, true), gettype($carriedKeyName)), __LINE__);
        }
        $this->CarriedKeyName = $carriedKeyName;
        return $this;
    }
    /**
     * Get Recipient value
     * @return string|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param string $recipient
     * @return \StructType\EncryptedKeyType
     */
    public function setRecipient($recipient = null)
    {
        // validation for constraint: string
        if (!is_null($recipient) && !is_string($recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipient, true), gettype($recipient)), __LINE__);
        }
        $this->Recipient = $recipient;
        return $this;
    }
}
