<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EncodedString StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is used for elements containing stringified binary data.
 * @subpackage Structs
 */
class EncodedString extends AttributedString
{
    /**
     * The _
     * @var \StructType\AttributedString
     */
    public $_;
    /**
     * The EncodingType
     * @var string
     */
    public $EncodingType;
    /**
     * Constructor method for EncodedString
     * @uses EncodedString::set_()
     * @uses EncodedString::setEncodingType()
     * @param \StructType\AttributedString $_
     * @param string $encodingType
     */
    public function __construct(\StructType\AttributedString $_ = null, $encodingType = null)
    {
        $this
            ->set_($_)
            ->setEncodingType($encodingType);
    }
    /**
     * Get _ value
     * @return \StructType\AttributedString|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\AttributedString $_
     * @return \StructType\EncodedString
     */
    public function set_(\StructType\AttributedString $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get EncodingType value
     * @return string|null
     */
    public function getEncodingType()
    {
        return $this->EncodingType;
    }
    /**
     * Set EncodingType value
     * @param string $encodingType
     * @return \StructType\EncodedString
     */
    public function setEncodingType($encodingType = null)
    {
        // validation for constraint: string
        if (!is_null($encodingType) && !is_string($encodingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encodingType, true), gettype($encodingType)), __LINE__);
        }
        $this->EncodingType = $encodingType;
        return $this;
    }
}
