<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Typ für die technisch neutrale (base64-kodierte) Darstellung von Information. Enthält den base64-kodierten Inhalt (Fachnachricht), der zwischen WebService-Client und XTA-Server transportiert wird. Die Attribute sind der
 * MIME-Spezifikation (RFC 2183) entnommen.Die Belegung der Attribute ist für verschiedene Fachlichkeiten unterschiedlich und ist durch den Fachstandard festzulegen, der für die Fachnachricht verantwortlich ist.
 * @subpackage Structs
 */
class ContentType extends AbstractStructBase
{
    /**
     * The contentType
     * Meta information extracted from the WSDL
     * - documentation: Dieses Attribut nennt den MIME-Typ des enthaltenen Inhalts, hat also Einträge wie text/xml, text/plain, application/gzip oder application/pdf. Mandatorisch, weil besonders wichtige Information (wird in E-Mail analog gehandhabt).
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $contentType;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The contentDescription
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung des fachlichen Inhalts, z.B. 'Angebot' oder 'Rechnung'.
     * - base: xs:string
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $contentDescription;
    /**
     * The encoding
     * Meta information extracted from the WSDL
     * - documentation: Der Zeichensatz, der der Kodierung des Inhalts zugrunde gelegen hat.
     * - base: xs:string
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $encoding;
    /**
     * The filename
     * Meta information extracted from the WSDL
     * - documentation: Der Dateiname der Datenquelle, falls der Inhalt einer Datei entnommen worden ist. Bsp.: Für die Übermittlung von xdomea-Nachrichten ist dieses Attribut Pflicht.
     * - base: xs:string
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $filename;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Bietet die Möglichkeit, den Inhalt über z.B. eine laufende Nummer zu referenzieren.
     * - use: optional
     * @var string
     */
    public $id;
    /**
     * The lang
     * Meta information extracted from the WSDL
     * - documentation: Sprache, in der der Inhalt formuliert ist.
     * - use: optional
     * @var string
     */
    public $lang;
    /**
     * The size
     * Meta information extracted from the WSDL
     * - documentation: Die Größe des Inhalts in Bytes.
     * - use: optional
     * @var int
     */
    public $size;
    /**
     * Constructor method for ContentType
     * @uses ContentType::setContentType()
     * @uses ContentType::set_()
     * @uses ContentType::setContentDescription()
     * @uses ContentType::setEncoding()
     * @uses ContentType::setFilename()
     * @uses ContentType::setId()
     * @uses ContentType::setLang()
     * @uses ContentType::setSize()
     * @param string $contentType
     * @param string $_
     * @param string $contentDescription
     * @param string $encoding
     * @param string $filename
     * @param string $id
     * @param string $lang
     * @param int $size
     */
    public function __construct($contentType = null, $_ = null, $contentDescription = null, $encoding = null, $filename = null, $id = null, $lang = null, $size = null)
    {
        $this
            ->setContentType($contentType)
            ->set_($_)
            ->setContentDescription($contentDescription)
            ->setEncoding($encoding)
            ->setFilename($filename)
            ->setId($id)
            ->setLang($lang)
            ->setSize($size);
    }
    /**
     * Get contentType value
     * @return string
     */
    public function getContentType()
    {
        return $this->contentType;
    }
    /**
     * Set contentType value
     * @param string $contentType
     * @return \StructType\ContentType
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contentType) && mb_strlen($contentType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contentType)), __LINE__);
        }
        $this->contentType = $contentType;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ContentType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get contentDescription value
     * @return string|null
     */
    public function getContentDescription()
    {
        return $this->contentDescription;
    }
    /**
     * Set contentDescription value
     * @param string $contentDescription
     * @return \StructType\ContentType
     */
    public function setContentDescription($contentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($contentDescription) && !is_string($contentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDescription, true), gettype($contentDescription)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contentDescription) && mb_strlen($contentDescription) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contentDescription)), __LINE__);
        }
        $this->contentDescription = $contentDescription;
        return $this;
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @param string $encoding
     * @return \StructType\ContentType
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encoding, true), gettype($encoding)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($encoding) && mb_strlen($encoding) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($encoding)), __LINE__);
        }
        $this->encoding = $encoding;
        return $this;
    }
    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\ContentType
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($filename) && mb_strlen($filename) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ContentType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\ContentType
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\ContentType
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
}
