<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CipherReferenceType StructType
 * @subpackage Structs
 */
class CipherReferenceType extends AbstractStructBase
{
    /**
     * The URI
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $URI;
    /**
     * The Transforms
     * Meta information extracted from the WSDL
     * - choice: Transforms
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransformsType
     */
    public $Transforms;
    /**
     * Constructor method for CipherReferenceType
     * @uses CipherReferenceType::setURI()
     * @uses CipherReferenceType::setTransforms()
     * @param string $uRI
     * @param \StructType\TransformsType $transforms
     */
    public function __construct($uRI = null, \StructType\TransformsType $transforms = null)
    {
        $this
            ->setURI($uRI)
            ->setTransforms($transforms);
    }
    /**
     * Get URI value
     * @return string
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\CipherReferenceType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Transforms value
     * @return \StructType\TransformsType|null
     */
    public function getTransforms()
    {
        return isset($this->Transforms) ? $this->Transforms : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTransforms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransforms method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTransformsForChoiceConstraintsFromSetTransforms($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Transforms can\'t be set as the property %s is already set. Only one property must be set among these properties: Transforms, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Transforms value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransformsType $transforms
     * @return \StructType\CipherReferenceType
     */
    public function setTransforms(\StructType\TransformsType $transforms = null)
    {
        // validation for constraint: choice(Transforms)
        if ('' !== ($transformsChoiceErrorMessage = self::validateTransformsForChoiceConstraintsFromSetTransforms($transforms))) {
            throw new \InvalidArgumentException($transformsChoiceErrorMessage, __LINE__);
        }
        if (is_null($transforms) || (is_array($transforms) && empty($transforms))) {
            unset($this->Transforms);
        } else {
            $this->Transforms = $transforms;
        }
        return $this;
    }
}
