<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessScenario StructType
 * Meta information extracted from the WSDL
 * - documentation: Domain qualifier, e.g. Meldewesen, XVergabe...
 * @subpackage Structs
 */
class BusinessScenario extends AbstractStructBase
{
    /**
     * The Defined
     * Meta information extracted from the WSDL
     * - choice: Defined | Undefined
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\KeyCodeType
     */
    public $Defined;
    /**
     * The Undefined
     * Meta information extracted from the WSDL
     * - choice: Defined | Undefined
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $Undefined;
    /**
     * Constructor method for BusinessScenario
     * @uses BusinessScenario::setDefined()
     * @uses BusinessScenario::setUndefined()
     * @param \StructType\KeyCodeType $defined
     * @param string $undefined
     */
    public function __construct(\StructType\KeyCodeType $defined = null, $undefined = null)
    {
        $this
            ->setDefined($defined)
            ->setUndefined($undefined);
    }
    /**
     * Get Defined value
     * @return \StructType\KeyCodeType|null
     */
    public function getDefined()
    {
        return isset($this->Defined) ? $this->Defined : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDefined method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefined method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDefinedForChoiceConstraintsFromSetDefined($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Undefined',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Defined can\'t be set as the property %s is already set. Only one property must be set among these properties: Defined, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Defined value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KeyCodeType $defined
     * @return \StructType\BusinessScenario
     */
    public function setDefined(\StructType\KeyCodeType $defined = null)
    {
        // validation for constraint: choice(Defined, Undefined)
        if ('' !== ($definedChoiceErrorMessage = self::validateDefinedForChoiceConstraintsFromSetDefined($defined))) {
            throw new \InvalidArgumentException($definedChoiceErrorMessage, __LINE__);
        }
        if (is_null($defined) || (is_array($defined) && empty($defined))) {
            unset($this->Defined);
        } else {
            $this->Defined = $defined;
        }
        return $this;
    }
    /**
     * Get Undefined value
     * @return string|null
     */
    public function getUndefined()
    {
        return isset($this->Undefined) ? $this->Undefined : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUndefined method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUndefined method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUndefinedForChoiceConstraintsFromSetUndefined($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Defined',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Undefined can\'t be set as the property %s is already set. Only one property must be set among these properties: Undefined, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Undefined value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $undefined
     * @return \StructType\BusinessScenario
     */
    public function setUndefined($undefined = null)
    {
        // validation for constraint: string
        if (!is_null($undefined) && !is_string($undefined)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($undefined, true), gettype($undefined)), __LINE__);
        }
        // validation for constraint: choice(Defined, Undefined)
        if ('' !== ($undefinedChoiceErrorMessage = self::validateUndefinedForChoiceConstraintsFromSetUndefined($undefined))) {
            throw new \InvalidArgumentException($undefinedChoiceErrorMessage, __LINE__);
        }
        if (is_null($undefined) || (is_array($undefined) && empty($undefined))) {
            unset($this->Undefined);
        } else {
            $this->Undefined = $undefined;
        }
        return $this;
    }
}
