<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Sets the MessageMetaData SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\MessageMetaData $messageMetaData
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMessageMetaData(\StructType\MessageMetaData $messageMetaData, $nameSpace = 'http://www.osci.eu/ws/2014/10/transport', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MessageMetaData', $messageMetaData, $mustUnderstand, $actor);
    }
    /**
     * Sets the X509TokenContainer SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\X509TokenContainerType $x509TokenContainer
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderX509TokenContainer(\StructType\X509TokenContainerType $x509TokenContainer, $nameSpace = 'http://www.osci.eu/ws/2008/05/transport', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'X509TokenContainer', $x509TokenContainer, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named sendMessage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: MessageMetaData, X509TokenContainer
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport, http://www.osci.eu/ws/2008/05/transport
     * - SOAPHeaderTypes: \StructType\MessageMetaData, \StructType\X509TokenContainerType
     * - SOAPHeaders: required, required
     * - documentation: The sendMessage method delivers a content message to the sending hub. | Input Header: MessageMetaData header contains additional information for the for the given payload. Body: The GenericContainerBody containins the "xöv" message.
     * | only for exception handling
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenericContentContainer $genericContainer
     * @return void|bool
     */
    public function sendMessage(\StructType\GenericContentContainer $genericContainer)
    {
        try {
            $this->setResult($this->getSoapClient()->sendMessage($genericContainer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendMessageSync
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: MessageMetaData, X509TokenContainer
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport, http://www.osci.eu/ws/2008/05/transport
     * - SOAPHeaderTypes: \StructType\MessageMetaData, \StructType\X509TokenContainerType
     * - SOAPHeaders: required, required
     * - documentation: The sendMessage method delivers a content message to the sending hub. | Input Header: MessageMetaData header contains additional information for the for the given payload. Body: The GenericContainerBody contains the "xöv" message. |
     * Output body: A GenericContainerBody in the body, containing the synchronous "xöv" message response.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenericContentContainer $genericContainer
     * @return \StructType\GenericContentContainer|bool
     */
    public function sendMessageSync(\StructType\GenericContentContainer $genericContainer)
    {
        try {
            $this->setResult($this->getSoapClient()->sendMessageSync($genericContainer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void|\StructType\GenericContentContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
