<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lookup ServiceType
 * @subpackage Services
 */
class Lookup extends AbstractSoapClientBase
{
    /**
     * Sets the Author SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\PartyType $author
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthor(\StructType\PartyType $author, $nameSpace = 'http://www.osci.eu/ws/2014/10/transport', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Author', $author, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named lookupService
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Author
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport
     * - SOAPHeaderTypes: \StructType\PartyType
     * - SOAPHeaders: required
     * - documentation: Method to get further information about the given address information | Input: optional xta:AuthorIdentifier header and a list of address information in the body part | Output body: further information for the given address list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LookupServiceRequest $lookupServiceRequest
     * @return \StructType\LookupServiceResponse|bool
     */
    public function lookupService(\StructType\LookupServiceRequest $lookupServiceRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->lookupService($lookupServiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LookupServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
