<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Author SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\PartyType $author
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthor(\StructType\PartyType $author, $nameSpace = 'http://www.osci.eu/ws/2014/10/transport', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Author', $author, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named createMessageId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Author
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport
     * - SOAPHeaderTypes: \StructType\PartyType
     * - SOAPHeaders: required
     * - documentation: Method to obtain new created MesMessageID | Input: optional xta:AuthorIdentifier header | Output body: The created MesMessageID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\AttributedURIType|bool
     */
    public function createMessageId()
    {
        try {
            $this->setResult($this->getSoapClient()->createMessageId());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AttributedURIType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
