<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Sets the Author SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\PartyType $author
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthor(\StructType\PartyType $author, $nameSpace = 'http://www.osci.eu/ws/2014/10/transport', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Author', $author, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named checkAccountActive
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Author
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport
     * - SOAPHeaderTypes: \StructType\PartyType
     * - SOAPHeaders: required
     * - documentation: only for exception handling | Method to check whether the account is activ | Input: optional xta:AuthorIdentifier header. | only for exception handling
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return void|bool
     */
    public function checkAccountActive()
    {
        try {
            $this->setResult($this->getSoapClient()->checkAccountActive());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
