<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://xta-test.govconnect.de/ws/xta2/?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://xta-test.govconnect.de/ws/xta2/?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthor($Author);
/**
 * Sample call for getMessage operation/method
 */
if ($get->getMessage(new \StructType\MsgBoxFetchRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStatusList operation/method
 */
if ($get->getStatusList(new \StructType\MsgBoxStatusListRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNextMessage operation/method
 */
if ($get->getNextMessage(new \StructType\MsgBoxGetNextRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNextStatusList operation/method
 */
if ($get->getNextStatusList(new \StructType\MsgBoxGetNextRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTransportReport operation/method
 */
if ($get->getTransportReport(new \StructType\AttributedURIType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \ServiceType\Close($options);
$close->setSoapHeaderAuthor($Author);
/**
 * Sample call for close operation/method
 */
if ($close->close(new \StructType\MsgBoxCloseRequestType()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
$send->setSoapHeaderMessageMetaData(new \StructType\MessageMetaData());
$send->setSoapHeaderX509TokenContainer($X509TokenContainer);
/**
 * Sample call for sendMessage operation/method
 */
if ($send->sendMessage(new \StructType\GenericContentContainer()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendMessageSync operation/method
 */
if ($send->sendMessageSync(new \StructType\GenericContentContainer()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
$cancel->setSoapHeaderAuthor($Author);
/**
 * Sample call for cancelMessage operation/method
 */
if ($cancel->cancelMessage(new \StructType\AttributedURIType()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Lookup ServiceType
 */
$lookup = new \ServiceType\Lookup($options);
$lookup->setSoapHeaderAuthor($Author);
/**
 * Sample call for lookupService operation/method
 */
if ($lookup->lookupService(new \StructType\LookupServiceRequest()) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
$check->setSoapHeaderAuthor($Author);
/**
 * Sample call for checkAccountActive operation/method
 */
if ($check->checkAccountActive() !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderAuthor($Author);
/**
 * Sample call for createMessageId operation/method
 */
if ($create->createMessageId() !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
