<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for X509TokenInfo StructType
 * @subpackage Structs
 */
class X509TokenInfo extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Id;
    /**
     * The X509Data
     * Meta information extracted from the WSDL
     * - ref: ds:X509Data
     * @var \StructType\X509DataType
     */
    public $X509Data;
    /**
     * The TokenApplication
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TokenApplication[]
     */
    public $TokenApplication;
    /**
     * The validated
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $validated;
    /**
     * Constructor method for X509TokenInfo
     * @uses X509TokenInfo::setId()
     * @uses X509TokenInfo::setX509Data()
     * @uses X509TokenInfo::setTokenApplication()
     * @uses X509TokenInfo::setValidated()
     * @param string $id
     * @param \StructType\X509DataType $x509Data
     * @param \StructType\TokenApplication[] $tokenApplication
     * @param bool $validated
     */
    public function __construct($id = null, \StructType\X509DataType $x509Data = null, array $tokenApplication = array(), $validated = false)
    {
        $this
            ->setId($id)
            ->setX509Data($x509Data)
            ->setTokenApplication($tokenApplication)
            ->setValidated($validated);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\X509TokenInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get X509Data value
     * @return \StructType\X509DataType|null
     */
    public function getX509Data()
    {
        return $this->X509Data;
    }
    /**
     * Set X509Data value
     * @param \StructType\X509DataType $x509Data
     * @return \StructType\X509TokenInfo
     */
    public function setX509Data(\StructType\X509DataType $x509Data = null)
    {
        $this->X509Data = $x509Data;
        return $this;
    }
    /**
     * Get TokenApplication value
     * @return \StructType\TokenApplication[]|null
     */
    public function getTokenApplication()
    {
        return $this->TokenApplication;
    }
    /**
     * This method is responsible for validating the values passed to the setTokenApplication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTokenApplication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTokenApplicationForArrayConstraintsFromSetTokenApplication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $x509TokenInfoTokenApplicationItem) {
            // validation for constraint: itemType
            if (!$x509TokenInfoTokenApplicationItem instanceof \StructType\TokenApplication) {
                $invalidValues[] = is_object($x509TokenInfoTokenApplicationItem) ? get_class($x509TokenInfoTokenApplicationItem) : sprintf('%s(%s)', gettype($x509TokenInfoTokenApplicationItem), var_export($x509TokenInfoTokenApplicationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TokenApplication property can only contain items of type \StructType\TokenApplication, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TokenApplication value
     * @throws \InvalidArgumentException
     * @param \StructType\TokenApplication[] $tokenApplication
     * @return \StructType\X509TokenInfo
     */
    public function setTokenApplication(array $tokenApplication = array())
    {
        // validation for constraint: array
        if ('' !== ($tokenApplicationArrayErrorMessage = self::validateTokenApplicationForArrayConstraintsFromSetTokenApplication($tokenApplication))) {
            throw new \InvalidArgumentException($tokenApplicationArrayErrorMessage, __LINE__);
        }
        $this->TokenApplication = $tokenApplication;
        return $this;
    }
    /**
     * Add item to TokenApplication value
     * @throws \InvalidArgumentException
     * @param \StructType\TokenApplication $item
     * @return \StructType\X509TokenInfo
     */
    public function addToTokenApplication(\StructType\TokenApplication $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TokenApplication) {
            throw new \InvalidArgumentException(sprintf('The TokenApplication property can only contain items of type \StructType\TokenApplication, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TokenApplication[] = $item;
        return $this;
    }
    /**
     * Get validated value
     * @return bool|null
     */
    public function getValidated()
    {
        return $this->validated;
    }
    /**
     * Set validated value
     * @param bool $validated
     * @return \StructType\X509TokenInfo
     */
    public function setValidated($validated = false)
    {
        // validation for constraint: boolean
        if (!is_null($validated) && !is_bool($validated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validated, true), gettype($validated)), __LINE__);
        }
        $this->validated = $validated;
        return $this;
    }
}
