<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subcode StructType
 * @subpackage Structs
 */
class Subcode extends AbstractStructBase
{
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * The Subcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Subcode
     */
    public $Subcode;
    /**
     * Constructor method for subcode
     * @uses Subcode::setValue()
     * @uses Subcode::setSubcode()
     * @param string $value
     * @param \StructType\Subcode $subcode
     */
    public function __construct($value = null, \StructType\Subcode $subcode = null)
    {
        $this
            ->setValue($value)
            ->setSubcode($subcode);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Subcode
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Subcode value
     * @return \StructType\Subcode|null
     */
    public function getSubcode()
    {
        return $this->Subcode;
    }
    /**
     * Set Subcode value
     * @param \StructType\Subcode $subcode
     * @return \StructType\Subcode
     */
    public function setSubcode(\StructType\Subcode $subcode = null)
    {
        $this->Subcode = $subcode;
        return $this;
    }
}
