<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceParameter StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieses Element enthält im Erfolgsfall die benötigten technischen Parameter für die elektronische Kommunikation mit dem Leser, z.B. das öffentliche Zertifikat des Lesers zur Inhaltsdatenverschlüsselung. Das Feld ist zu füllen,
 * falls der angefragte Dienst angeboten und in diesem Kontext der Parameter benötigt wird.Vom Fachszenario ist zu beschreiben, welche Parameter für die Erreichbarkeit der Dienste in diesem Fachszenario anzuwenden sind.
 * @subpackage Structs
 */
class ServiceParameter extends AbstractStructBase
{
    /**
     * The ParameterType
     * Meta information extracted from the WSDL
     * - documentation: Dieses Element steht für die Art des Parameters, welche ins passende Kindelement einzutragen bzw. eingetragen ist. Die vorgesehenen Parameterarten werden auf der Basis einer Codeliste interpretiert, welche durch die Attribute
     * listURI und listVersionID referenziert ist.
     * @var \StructType\Code_ServiceParameterType
     */
    public $ParameterType;
    /**
     * The Resource
     * Meta information extracted from the WSDL
     * - documentation: Hier ist der Parameter enthalten bzw. einnzutragen in technisch neutraler Darstellung.
     * @var string
     */
    public $Resource;
    /**
     * Constructor method for ServiceParameter
     * @uses ServiceParameter::setParameterType()
     * @uses ServiceParameter::setResource()
     * @param \StructType\Code_ServiceParameterType $parameterType
     * @param string $resource
     */
    public function __construct(\StructType\Code_ServiceParameterType $parameterType = null, $resource = null)
    {
        $this
            ->setParameterType($parameterType)
            ->setResource($resource);
    }
    /**
     * Get ParameterType value
     * @return \StructType\Code_ServiceParameterType|null
     */
    public function getParameterType()
    {
        return $this->ParameterType;
    }
    /**
     * Set ParameterType value
     * @param \StructType\Code_ServiceParameterType $parameterType
     * @return \StructType\ServiceParameter
     */
    public function setParameterType(\StructType\Code_ServiceParameterType $parameterType = null)
    {
        $this->ParameterType = $parameterType;
        return $this;
    }
    /**
     * Get Resource value
     * @return string|null
     */
    public function getResource()
    {
        return $this->Resource;
    }
    /**
     * Set Resource value
     * @param string $resource
     * @return \StructType\ServiceParameter
     */
    public function setResource($resource = null)
    {
        // validation for constraint: string
        if (!is_null($resource) && !is_string($resource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource, true), gettype($resource)), __LINE__);
        }
        $this->Resource = $resource;
        return $this;
    }
}
