<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Report StructType
 * Meta information extracted from the WSDL
 * - documentation: In diesem Element ist ein zusätzlicher Report abgelegt, der das XTA-Protokoll (TransportReport) ergänzt. Die Art des Reports (z. B. OSCI Process Card) und der Inhalt des Reports werden bzw. sind in separaten Bereichen dieses
 * Containers eingetragen.
 * @subpackage Structs
 */
class Report extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - documentation: Dieses Element benennt den Typ des Reports, um dem Leser die Interpretation der Reportdaten zu ermöglichen. Die Benennung des Typs des Reports geschieht auf der Basis einer Codeliste.
     * @var \StructType\Code_ReportType
     */
    public $Key;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - documentation: Hier wird der zusätzliche Report in einem technisch neutralen Format eingetragen.
     * @var string
     */
    public $Data;
    /**
     * Constructor method for Report
     * @uses Report::setKey()
     * @uses Report::setData()
     * @param \StructType\Code_ReportType $key
     * @param string $data
     */
    public function __construct(\StructType\Code_ReportType $key = null, $data = null)
    {
        $this
            ->setKey($key)
            ->setData($data);
    }
    /**
     * Get Key value
     * @return \StructType\Code_ReportType|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param \StructType\Code_ReportType $key
     * @return \StructType\Report
     */
    public function setKey(\StructType\Code_ReportType $key = null)
    {
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \StructType\Report
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
}
