<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceList StructType
 * @subpackage Structs
 */
class ReferenceList extends AbstractStructBase
{
    /**
     * The DataReference
     * Meta information extracted from the WSDL
     * - choice: DataReference | KeyReference
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * @var \StructType\ReferenceType
     */
    public $DataReference;
    /**
     * The KeyReference
     * Meta information extracted from the WSDL
     * - choice: DataReference | KeyReference
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * @var \StructType\ReferenceType
     */
    public $KeyReference;
    /**
     * Constructor method for ReferenceList
     * @uses ReferenceList::setDataReference()
     * @uses ReferenceList::setKeyReference()
     * @param \StructType\ReferenceType $dataReference
     * @param \StructType\ReferenceType $keyReference
     */
    public function __construct(\StructType\ReferenceType $dataReference = null, \StructType\ReferenceType $keyReference = null)
    {
        $this
            ->setDataReference($dataReference)
            ->setKeyReference($keyReference);
    }
    /**
     * Get DataReference value
     * @return \StructType\ReferenceType|null
     */
    public function getDataReference()
    {
        return isset($this->DataReference) ? $this->DataReference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDataReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDataReference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDataReferenceForChoiceConstraintsFromSetDataReference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyReference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DataReference can\'t be set as the property %s is already set. Only one property must be set among these properties: DataReference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DataReference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceType $dataReference
     * @return \StructType\ReferenceList
     */
    public function setDataReference(\StructType\ReferenceType $dataReference = null)
    {
        // validation for constraint: choice(DataReference, KeyReference)
        if ('' !== ($dataReferenceChoiceErrorMessage = self::validateDataReferenceForChoiceConstraintsFromSetDataReference($dataReference))) {
            throw new \InvalidArgumentException($dataReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($dataReference) || (is_array($dataReference) && empty($dataReference))) {
            unset($this->DataReference);
        } else {
            $this->DataReference = $dataReference;
        }
        return $this;
    }
    /**
     * Get KeyReference value
     * @return \StructType\ReferenceType|null
     */
    public function getKeyReference()
    {
        return isset($this->KeyReference) ? $this->KeyReference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setKeyReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyReference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKeyReferenceForChoiceConstraintsFromSetKeyReference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DataReference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property KeyReference can\'t be set as the property %s is already set. Only one property must be set among these properties: KeyReference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set KeyReference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceType $keyReference
     * @return \StructType\ReferenceList
     */
    public function setKeyReference(\StructType\ReferenceType $keyReference = null)
    {
        // validation for constraint: choice(DataReference, KeyReference)
        if ('' !== ($keyReferenceChoiceErrorMessage = self::validateKeyReferenceForChoiceConstraintsFromSetKeyReference($keyReference))) {
            throw new \InvalidArgumentException($keyReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($keyReference) || (is_array($keyReference) && empty($keyReference))) {
            unset($this->KeyReference);
        } else {
            $this->KeyReference = $keyReference;
        }
        return $this;
    }
}
