<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiptRequestType StructType
 * @subpackage Structs
 */
class ReceiptRequestType extends AbstractStructBase
{
    /**
     * The Submission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Submission;
    /**
     * The Relay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Relay;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Delivery;
    /**
     * The Fetch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Fetch;
    /**
     * The Reception
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Reception;
    /**
     * The ReceiptTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EndpointReferenceType
     */
    public $ReceiptTo;
    /**
     * Constructor method for ReceiptRequestType
     * @uses ReceiptRequestType::setSubmission()
     * @uses ReceiptRequestType::setRelay()
     * @uses ReceiptRequestType::setDelivery()
     * @uses ReceiptRequestType::setFetch()
     * @uses ReceiptRequestType::setReception()
     * @uses ReceiptRequestType::setReceiptTo()
     * @param mixed $submission
     * @param mixed $relay
     * @param mixed $delivery
     * @param mixed $fetch
     * @param mixed $reception
     * @param \StructType\EndpointReferenceType $receiptTo
     */
    public function __construct($submission = null, $relay = null, $delivery = null, $fetch = null, $reception = null, \StructType\EndpointReferenceType $receiptTo = null)
    {
        $this
            ->setSubmission($submission)
            ->setRelay($relay)
            ->setDelivery($delivery)
            ->setFetch($fetch)
            ->setReception($reception)
            ->setReceiptTo($receiptTo);
    }
    /**
     * Get Submission value
     * @return mixed|null
     */
    public function getSubmission()
    {
        return $this->Submission;
    }
    /**
     * Set Submission value
     * @param mixed $submission
     * @return \StructType\ReceiptRequestType
     */
    public function setSubmission($submission = null)
    {
        $this->Submission = $submission;
        return $this;
    }
    /**
     * Get Relay value
     * @return mixed|null
     */
    public function getRelay()
    {
        return $this->Relay;
    }
    /**
     * Set Relay value
     * @param mixed $relay
     * @return \StructType\ReceiptRequestType
     */
    public function setRelay($relay = null)
    {
        $this->Relay = $relay;
        return $this;
    }
    /**
     * Get Delivery value
     * @return mixed|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param mixed $delivery
     * @return \StructType\ReceiptRequestType
     */
    public function setDelivery($delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get Fetch value
     * @return mixed|null
     */
    public function getFetch()
    {
        return $this->Fetch;
    }
    /**
     * Set Fetch value
     * @param mixed $fetch
     * @return \StructType\ReceiptRequestType
     */
    public function setFetch($fetch = null)
    {
        $this->Fetch = $fetch;
        return $this;
    }
    /**
     * Get Reception value
     * @return mixed|null
     */
    public function getReception()
    {
        return $this->Reception;
    }
    /**
     * Set Reception value
     * @param mixed $reception
     * @return \StructType\ReceiptRequestType
     */
    public function setReception($reception = null)
    {
        $this->Reception = $reception;
        return $this;
    }
    /**
     * Get ReceiptTo value
     * @return \StructType\EndpointReferenceType|null
     */
    public function getReceiptTo()
    {
        return $this->ReceiptTo;
    }
    /**
     * Set ReceiptTo value
     * @param \StructType\EndpointReferenceType $receiptTo
     * @return \StructType\ReceiptRequestType
     */
    public function setReceiptTo(\StructType\EndpointReferenceType $receiptTo = null)
    {
        $this->ReceiptTo = $receiptTo;
        return $this;
    }
}
