<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QualifierType StructType
 * @subpackage Structs
 */
class QualifierType extends AbstractStructBase
{
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - documentation: Message subject text (informational)
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Distinct service in a certain business scenario context; in the XÖV context this is the "Dienste URI"
     * @var string
     */
    public $Service;
    /**
     * The BusinessScenario
     * @var \StructType\BusinessScenario
     */
    public $BusinessScenario;
    /**
     * The MessageType
     * @var \StructType\MessageType
     */
    public $MessageType;
    /**
     * Constructor method for QualifierType
     * @uses QualifierType::setSubject()
     * @uses QualifierType::setService()
     * @uses QualifierType::setBusinessScenario()
     * @uses QualifierType::setMessageType()
     * @param string $subject
     * @param string $service
     * @param \StructType\BusinessScenario $businessScenario
     * @param \StructType\MessageType $messageType
     */
    public function __construct($subject = null, $service = null, \StructType\BusinessScenario $businessScenario = null, \StructType\MessageType $messageType = null)
    {
        $this
            ->setSubject($subject)
            ->setService($service)
            ->setBusinessScenario($businessScenario)
            ->setMessageType($messageType);
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\QualifierType
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Service value
     * @return string|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param string $service
     * @return \StructType\QualifierType
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Get BusinessScenario value
     * @return \StructType\BusinessScenario|null
     */
    public function getBusinessScenario()
    {
        return $this->BusinessScenario;
    }
    /**
     * Set BusinessScenario value
     * @param \StructType\BusinessScenario $businessScenario
     * @return \StructType\QualifierType
     */
    public function setBusinessScenario(\StructType\BusinessScenario $businessScenario = null)
    {
        $this->BusinessScenario = $businessScenario;
        return $this;
    }
    /**
     * Get MessageType value
     * @return \StructType\MessageType|null
     */
    public function getMessageType()
    {
        return $this->MessageType;
    }
    /**
     * Set MessageType value
     * @param \StructType\MessageType $messageType
     * @return \StructType\QualifierType
     */
    public function setMessageType(\StructType\MessageType $messageType = null)
    {
        $this->MessageType = $messageType;
        return $this;
    }
}
