<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyType StructType
 * @subpackage Structs
 */
class PropertyType extends AbstractStructBase
{
    /**
     * The Key
     * @var \StructType\KeyCodeType
     */
    public $Key;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * @var string
     */
    public $Value;
    /**
     * Constructor method for PropertyType
     * @uses PropertyType::setKey()
     * @uses PropertyType::setValue()
     * @param \StructType\KeyCodeType $key
     * @param string $value
     */
    public function __construct(\StructType\KeyCodeType $key = null, $value = null)
    {
        $this
            ->setKey($key)
            ->setValue($value);
    }
    /**
     * Get Key value
     * @return \StructType\KeyCodeType|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param \StructType\KeyCodeType $key
     * @return \StructType\PropertyType
     */
    public function setKey(\StructType\KeyCodeType $key = null)
    {
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\PropertyType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($value) && mb_strlen($value) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
