<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyReference StructType
 * @subpackage Structs
 */
class PolicyReference extends AbstractStructBase
{
    /**
     * The URI
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $URI;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The Digest
     * @var string
     */
    public $Digest;
    /**
     * The DigestAlgorithm
     * Meta information extracted from the WSDL
     * - default: http://www.w3.org/ns/ws-policy/Sha1Exc
     * @var string
     */
    public $DigestAlgorithm;
    /**
     * Constructor method for PolicyReference
     * @uses PolicyReference::setURI()
     * @uses PolicyReference::setAny()
     * @uses PolicyReference::setDigest()
     * @uses PolicyReference::setDigestAlgorithm()
     * @param string $uRI
     * @param \DOMDocument $any
     * @param string $digest
     * @param string $digestAlgorithm
     */
    public function __construct($uRI = null, \DOMDocument $any = null, $digest = null, $digestAlgorithm = 'http://www.w3.org/ns/ws-policy/Sha1Exc')
    {
        $this
            ->setURI($uRI)
            ->setAny($any)
            ->setDigest($digest)
            ->setDigestAlgorithm($digestAlgorithm);
    }
    /**
     * Get URI value
     * @return string
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\PolicyReference
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\PolicyReference
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get Digest value
     * @return string|null
     */
    public function getDigest()
    {
        return $this->Digest;
    }
    /**
     * Set Digest value
     * @param string $digest
     * @return \StructType\PolicyReference
     */
    public function setDigest($digest = null)
    {
        // validation for constraint: string
        if (!is_null($digest) && !is_string($digest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digest, true), gettype($digest)), __LINE__);
        }
        $this->Digest = $digest;
        return $this;
    }
    /**
     * Get DigestAlgorithm value
     * @return string|null
     */
    public function getDigestAlgorithm()
    {
        return $this->DigestAlgorithm;
    }
    /**
     * Set DigestAlgorithm value
     * @param string $digestAlgorithm
     * @return \StructType\PolicyReference
     */
    public function setDigestAlgorithm($digestAlgorithm = 'http://www.w3.org/ns/ws-policy/Sha1Exc')
    {
        // validation for constraint: string
        if (!is_null($digestAlgorithm) && !is_string($digestAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestAlgorithm, true), gettype($digestAlgorithm)), __LINE__);
        }
        $this->DigestAlgorithm = $digestAlgorithm;
        return $this;
    }
}
