<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherDestinations StructType
 * Meta information extracted from the WSDL
 * - documentation: Other destinations of message - informational, as known from e-mail
 * @subpackage Structs
 */
class OtherDestinations extends AbstractStructBase
{
    /**
     * The OtherReaders
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: oscimeta:OtherReaders
     * @var \StructType\PartyIdentifierType[]
     */
    public $OtherReaders;
    /**
     * The CcReaders
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: oscimeta:CcReaders
     * @var \StructType\PartyIdentifierType[]
     */
    public $CcReaders;
    /**
     * Constructor method for OtherDestinations
     * @uses OtherDestinations::setOtherReaders()
     * @uses OtherDestinations::setCcReaders()
     * @param \StructType\PartyIdentifierType[] $otherReaders
     * @param \StructType\PartyIdentifierType[] $ccReaders
     */
    public function __construct(array $otherReaders = array(), array $ccReaders = array())
    {
        $this
            ->setOtherReaders($otherReaders)
            ->setCcReaders($ccReaders);
    }
    /**
     * Get OtherReaders value
     * @return \StructType\PartyIdentifierType[]|null
     */
    public function getOtherReaders()
    {
        return $this->OtherReaders;
    }
    /**
     * This method is responsible for validating the values passed to the setOtherReaders method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherReaders method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherReadersForArrayConstraintsFromSetOtherReaders(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherDestinationsOtherReadersItem) {
            // validation for constraint: itemType
            if (!$otherDestinationsOtherReadersItem instanceof \StructType\PartyIdentifierType) {
                $invalidValues[] = is_object($otherDestinationsOtherReadersItem) ? get_class($otherDestinationsOtherReadersItem) : sprintf('%s(%s)', gettype($otherDestinationsOtherReadersItem), var_export($otherDestinationsOtherReadersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OtherReaders property can only contain items of type \StructType\PartyIdentifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OtherReaders value
     * @throws \InvalidArgumentException
     * @param \StructType\PartyIdentifierType[] $otherReaders
     * @return \StructType\OtherDestinations
     */
    public function setOtherReaders(array $otherReaders = array())
    {
        // validation for constraint: array
        if ('' !== ($otherReadersArrayErrorMessage = self::validateOtherReadersForArrayConstraintsFromSetOtherReaders($otherReaders))) {
            throw new \InvalidArgumentException($otherReadersArrayErrorMessage, __LINE__);
        }
        $this->OtherReaders = $otherReaders;
        return $this;
    }
    /**
     * Add item to OtherReaders value
     * @throws \InvalidArgumentException
     * @param \StructType\PartyIdentifierType $item
     * @return \StructType\OtherDestinations
     */
    public function addToOtherReaders(\StructType\PartyIdentifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartyIdentifierType) {
            throw new \InvalidArgumentException(sprintf('The OtherReaders property can only contain items of type \StructType\PartyIdentifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OtherReaders[] = $item;
        return $this;
    }
    /**
     * Get CcReaders value
     * @return \StructType\PartyIdentifierType[]|null
     */
    public function getCcReaders()
    {
        return $this->CcReaders;
    }
    /**
     * This method is responsible for validating the values passed to the setCcReaders method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCcReaders method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCcReadersForArrayConstraintsFromSetCcReaders(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherDestinationsCcReadersItem) {
            // validation for constraint: itemType
            if (!$otherDestinationsCcReadersItem instanceof \StructType\PartyIdentifierType) {
                $invalidValues[] = is_object($otherDestinationsCcReadersItem) ? get_class($otherDestinationsCcReadersItem) : sprintf('%s(%s)', gettype($otherDestinationsCcReadersItem), var_export($otherDestinationsCcReadersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CcReaders property can only contain items of type \StructType\PartyIdentifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CcReaders value
     * @throws \InvalidArgumentException
     * @param \StructType\PartyIdentifierType[] $ccReaders
     * @return \StructType\OtherDestinations
     */
    public function setCcReaders(array $ccReaders = array())
    {
        // validation for constraint: array
        if ('' !== ($ccReadersArrayErrorMessage = self::validateCcReadersForArrayConstraintsFromSetCcReaders($ccReaders))) {
            throw new \InvalidArgumentException($ccReadersArrayErrorMessage, __LINE__);
        }
        $this->CcReaders = $ccReaders;
        return $this;
    }
    /**
     * Add item to CcReaders value
     * @throws \InvalidArgumentException
     * @param \StructType\PartyIdentifierType $item
     * @return \StructType\OtherDestinations
     */
    public function addToCcReaders(\StructType\PartyIdentifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartyIdentifierType) {
            throw new \InvalidArgumentException(sprintf('The CcReaders property can only contain items of type \StructType\PartyIdentifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CcReaders[] = $item;
        return $this;
    }
}
