<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoMessageAvailable StructType
 * @subpackage Structs
 */
class NoMessageAvailable extends AbstractStructBase
{
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - union: MsgBoxReasonEnum | anyURI
     * - use: required
     * @var string
     */
    public $reason;
    /**
     * Constructor method for NoMessageAvailable
     * @uses NoMessageAvailable::setReason()
     * @param string $reason
     */
    public function __construct($reason = null)
    {
        $this
            ->setReason($reason);
    }
    /**
     * Get reason value
     * @return string
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * This method is responsible for validating the value passed to the setReason method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReason method
     * This is a set of validation rules based on the union types associated to the property being set by the setReason method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReasonForUnionConstraintsFromSetReason($value)
    {
        $message = '';
        // validation for constraint: enumeration
        if (!\EnumType\MsgBoxReasonEnum::valueIsValid($value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MsgBoxReasonEnum', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\MsgBoxReasonEnum::getValidValues())), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: MsgBoxReasonEnum, anyURI. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\NoMessageAvailable
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        // validation for constraint: union(MsgBoxReasonEnum, anyURI)
        if ('' !== ($reasonUnionErrorMessage = self::validateReasonForUnionConstraintsFromSetReason($reason))) {
            throw new \InvalidArgumentException($reasonUnionErrorMessage, __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
}
