<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payload: Type of document or message. MessageTypes normally bound to specific BusinessScenario
 * @subpackage Structs
 */
class MessageType extends KeyCodeType
{
    /**
     * The payloadSchema
     * Meta information extracted from the WSDL
     * - base: xs:anyURI
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $payloadSchema;
    /**
     * Constructor method for MessageType
     * @uses MessageType::setPayloadSchema()
     * @param string $payloadSchema
     */
    public function __construct($payloadSchema = null)
    {
        $this
            ->setPayloadSchema($payloadSchema);
    }
    /**
     * Get payloadSchema value
     * @return string
     */
    public function getPayloadSchema()
    {
        return $this->payloadSchema;
    }
    /**
     * Set payloadSchema value
     * @param string $payloadSchema
     * @return \StructType\MessageType
     */
    public function setPayloadSchema($payloadSchema = null)
    {
        // validation for constraint: string
        if (!is_null($payloadSchema) && !is_string($payloadSchema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payloadSchema, true), gettype($payloadSchema)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($payloadSchema) && mb_strlen($payloadSchema) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($payloadSchema)), __LINE__);
        }
        $this->payloadSchema = $payloadSchema;
        return $this;
    }
}
