<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageProperties StructType
 * Meta information extracted from the WSDL
 * - documentation: Scenarios specific payload properties, to be agreed upon per scenario
 * @subpackage Structs
 */
class MessageProperties extends AbstractStructBase
{
    /**
     * The Property
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PropertyType[]
     */
    public $Property;
    /**
     * Constructor method for MessageProperties
     * @uses MessageProperties::setProperty()
     * @param \StructType\PropertyType[] $property
     */
    public function __construct(array $property = array())
    {
        $this
            ->setProperty($property);
    }
    /**
     * Get Property value
     * @return \StructType\PropertyType[]|null
     */
    public function getProperty()
    {
        return $this->Property;
    }
    /**
     * This method is responsible for validating the values passed to the setProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyForArrayConstraintsFromSetProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $messagePropertiesPropertyItem) {
            // validation for constraint: itemType
            if (!$messagePropertiesPropertyItem instanceof \StructType\PropertyType) {
                $invalidValues[] = is_object($messagePropertiesPropertyItem) ? get_class($messagePropertiesPropertyItem) : sprintf('%s(%s)', gettype($messagePropertiesPropertyItem), var_export($messagePropertiesPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Property property can only contain items of type \StructType\PropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Property value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyType[] $property
     * @return \StructType\MessageProperties
     */
    public function setProperty(array $property = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyArrayErrorMessage = self::validatePropertyForArrayConstraintsFromSetProperty($property))) {
            throw new \InvalidArgumentException($propertyArrayErrorMessage, __LINE__);
        }
        $this->Property = $property;
        return $this;
    }
    /**
     * Add item to Property value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyType $item
     * @return \StructType\MessageProperties
     */
    public function addToProperty(\StructType\PropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropertyType) {
            throw new \InvalidArgumentException(sprintf('The Property property can only contain items of type \StructType\PropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Property[] = $item;
        return $this;
    }
}
