<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IsServiceAvailableValueType StructType
 * Meta information extracted from the WSDL
 * - documentation: Das Feld enthält die benötigten Attribute zum Ergebnis der Dienstanfrage: ob der Dienst angeboten wird oder nicht, oder ob diese Information generell nicht bekannt ist.
 * @subpackage Structs
 */
class IsServiceAvailableValueType extends AbstractStructBase
{
    /**
     * The ServiceIsAvailable
     * Meta information extracted from the WSDL
     * - documentation: Der Dienst wird angeboten (true) oder nicht angeboten (false).
     * - choice: ServiceIsAvailable | ServiceIsAvailableUnknown
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var bool
     */
    public $ServiceIsAvailable;
    /**
     * The ServiceIsAvailableUnknown
     * Meta information extracted from the WSDL
     * - documentation: Es ist nicht bekannt, ob der Dienst angeboten wird oder nicht.
     * - choice: ServiceIsAvailable | ServiceIsAvailableUnknown
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fixed: true
     * @var bool
     */
    public $ServiceIsAvailableUnknown;
    /**
     * Constructor method for IsServiceAvailableValueType
     * @uses IsServiceAvailableValueType::setServiceIsAvailable()
     * @uses IsServiceAvailableValueType::setServiceIsAvailableUnknown()
     * @param bool $serviceIsAvailable
     * @param bool $serviceIsAvailableUnknown
     */
    public function __construct($serviceIsAvailable = null, $serviceIsAvailableUnknown = null)
    {
        $this
            ->setServiceIsAvailable($serviceIsAvailable)
            ->setServiceIsAvailableUnknown($serviceIsAvailableUnknown);
    }
    /**
     * Get ServiceIsAvailable value
     * @return bool|null
     */
    public function getServiceIsAvailable()
    {
        return isset($this->ServiceIsAvailable) ? $this->ServiceIsAvailable : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceIsAvailable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceIsAvailable method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceIsAvailableForChoiceConstraintsFromSetServiceIsAvailable($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ServiceIsAvailableUnknown',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceIsAvailable can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceIsAvailable, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceIsAvailable value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $serviceIsAvailable
     * @return \StructType\IsServiceAvailableValueType
     */
    public function setServiceIsAvailable($serviceIsAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceIsAvailable) && !is_bool($serviceIsAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceIsAvailable, true), gettype($serviceIsAvailable)), __LINE__);
        }
        // validation for constraint: choice(ServiceIsAvailable, ServiceIsAvailableUnknown)
        if ('' !== ($serviceIsAvailableChoiceErrorMessage = self::validateServiceIsAvailableForChoiceConstraintsFromSetServiceIsAvailable($serviceIsAvailable))) {
            throw new \InvalidArgumentException($serviceIsAvailableChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceIsAvailable) || (is_array($serviceIsAvailable) && empty($serviceIsAvailable))) {
            unset($this->ServiceIsAvailable);
        } else {
            $this->ServiceIsAvailable = $serviceIsAvailable;
        }
        return $this;
    }
    /**
     * Get ServiceIsAvailableUnknown value
     * @return bool|null
     */
    public function getServiceIsAvailableUnknown()
    {
        return isset($this->ServiceIsAvailableUnknown) ? $this->ServiceIsAvailableUnknown : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceIsAvailableUnknown method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceIsAvailableUnknown method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceIsAvailableUnknownForChoiceConstraintsFromSetServiceIsAvailableUnknown($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ServiceIsAvailable',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceIsAvailableUnknown can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceIsAvailableUnknown, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceIsAvailableUnknown value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $serviceIsAvailableUnknown
     * @return \StructType\IsServiceAvailableValueType
     */
    public function setServiceIsAvailableUnknown($serviceIsAvailableUnknown = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceIsAvailableUnknown) && !is_bool($serviceIsAvailableUnknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceIsAvailableUnknown, true), gettype($serviceIsAvailableUnknown)), __LINE__);
        }
        // validation for constraint: choice(ServiceIsAvailable, ServiceIsAvailableUnknown)
        if ('' !== ($serviceIsAvailableUnknownChoiceErrorMessage = self::validateServiceIsAvailableUnknownForChoiceConstraintsFromSetServiceIsAvailableUnknown($serviceIsAvailableUnknown))) {
            throw new \InvalidArgumentException($serviceIsAvailableUnknownChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceIsAvailableUnknown) || (is_array($serviceIsAvailableUnknown) && empty($serviceIsAvailableUnknown))) {
            unset($this->ServiceIsAvailableUnknown);
        } else {
            $this->ServiceIsAvailableUnknown = $serviceIsAvailableUnknown;
        }
        return $this;
    }
}
