<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FetchedNotificationDemandType StructType
 * @subpackage Structs
 */
class FetchedNotificationDemandType extends AbstractStructBase
{
    /**
     * The ReplyTo
     * Meta information extracted from the WSDL
     * - ref: wsa:ReplyTo
     * @var \StructType\EndpointReferenceType
     */
    public $ReplyTo;
    /**
     * The role
     * Meta information extracted from the WSDL
     * - default: http://www.osci.eu/ws/2008/05/transport/role/MsgBox
     * - ref: s12:role
     * @var string
     */
    public $role;
    /**
     * Constructor method for FetchedNotificationDemandType
     * @uses FetchedNotificationDemandType::setReplyTo()
     * @uses FetchedNotificationDemandType::setRole()
     * @param \StructType\EndpointReferenceType $replyTo
     * @param string $role
     */
    public function __construct(\StructType\EndpointReferenceType $replyTo = null, $role = 'http://www.osci.eu/ws/2008/05/transport/role/MsgBox')
    {
        $this
            ->setReplyTo($replyTo)
            ->setRole($role);
    }
    /**
     * Get ReplyTo value
     * @return \StructType\EndpointReferenceType|null
     */
    public function getReplyTo()
    {
        return $this->ReplyTo;
    }
    /**
     * Set ReplyTo value
     * @param \StructType\EndpointReferenceType $replyTo
     * @return \StructType\FetchedNotificationDemandType
     */
    public function setReplyTo(\StructType\EndpointReferenceType $replyTo = null)
    {
        $this->ReplyTo = $replyTo;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\FetchedNotificationDemandType
     */
    public function setRole($role = 'http://www.osci.eu/ws/2008/05/transport/role/MsgBox')
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
}
