<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndpointReferenceType StructType
 * Meta information extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class EndpointReferenceType extends AbstractStructBase
{
    /**
     * The Address
     * @var \StructType\AttributedURIType
     */
    public $Address;
    /**
     * The ReferenceParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:ReferenceParameters
     * @var \StructType\ReferenceParametersType
     */
    public $ReferenceParameters;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Metadata
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for EndpointReferenceType
     * @uses EndpointReferenceType::setAddress()
     * @uses EndpointReferenceType::setReferenceParameters()
     * @uses EndpointReferenceType::setMetadata()
     * @uses EndpointReferenceType::setAny()
     * @param \StructType\AttributedURIType $address
     * @param \StructType\ReferenceParametersType $referenceParameters
     * @param \StructType\MetadataType $metadata
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\AttributedURIType $address = null, \StructType\ReferenceParametersType $referenceParameters = null, \StructType\MetadataType $metadata = null, \DOMDocument $any = null)
    {
        $this
            ->setAddress($address)
            ->setReferenceParameters($referenceParameters)
            ->setMetadata($metadata)
            ->setAny($any);
    }
    /**
     * Get Address value
     * @return \StructType\AttributedURIType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AttributedURIType $address
     * @return \StructType\EndpointReferenceType
     */
    public function setAddress(\StructType\AttributedURIType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ReferenceParameters value
     * @return \StructType\ReferenceParametersType|null
     */
    public function getReferenceParameters()
    {
        return $this->ReferenceParameters;
    }
    /**
     * Set ReferenceParameters value
     * @param \StructType\ReferenceParametersType $referenceParameters
     * @return \StructType\EndpointReferenceType
     */
    public function setReferenceParameters(\StructType\ReferenceParametersType $referenceParameters = null)
    {
        $this->ReferenceParameters = $referenceParameters;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\EndpointReferenceType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\EndpointReferenceType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
