<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EncryptionPropertiesType StructType
 * @subpackage Structs
 */
class EncryptionPropertiesType extends AbstractStructBase
{
    /**
     * The EncryptionProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: xenc:EncryptionProperty
     * @var \StructType\EncryptionPropertyType[]
     */
    public $EncryptionProperty;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for EncryptionPropertiesType
     * @uses EncryptionPropertiesType::setEncryptionProperty()
     * @uses EncryptionPropertiesType::setId()
     * @param \StructType\EncryptionPropertyType[] $encryptionProperty
     * @param string $id
     */
    public function __construct(array $encryptionProperty = array(), $id = null)
    {
        $this
            ->setEncryptionProperty($encryptionProperty)
            ->setId($id);
    }
    /**
     * Get EncryptionProperty value
     * @return \StructType\EncryptionPropertyType[]|null
     */
    public function getEncryptionProperty()
    {
        return $this->EncryptionProperty;
    }
    /**
     * This method is responsible for validating the values passed to the setEncryptionProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEncryptionProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEncryptionPropertyForArrayConstraintsFromSetEncryptionProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $encryptionPropertiesTypeEncryptionPropertyItem) {
            // validation for constraint: itemType
            if (!$encryptionPropertiesTypeEncryptionPropertyItem instanceof \StructType\EncryptionPropertyType) {
                $invalidValues[] = is_object($encryptionPropertiesTypeEncryptionPropertyItem) ? get_class($encryptionPropertiesTypeEncryptionPropertyItem) : sprintf('%s(%s)', gettype($encryptionPropertiesTypeEncryptionPropertyItem), var_export($encryptionPropertiesTypeEncryptionPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EncryptionProperty property can only contain items of type \StructType\EncryptionPropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EncryptionProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\EncryptionPropertyType[] $encryptionProperty
     * @return \StructType\EncryptionPropertiesType
     */
    public function setEncryptionProperty(array $encryptionProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($encryptionPropertyArrayErrorMessage = self::validateEncryptionPropertyForArrayConstraintsFromSetEncryptionProperty($encryptionProperty))) {
            throw new \InvalidArgumentException($encryptionPropertyArrayErrorMessage, __LINE__);
        }
        $this->EncryptionProperty = $encryptionProperty;
        return $this;
    }
    /**
     * Add item to EncryptionProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\EncryptionPropertyType $item
     * @return \StructType\EncryptionPropertiesType
     */
    public function addToEncryptionProperty(\StructType\EncryptionPropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EncryptionPropertyType) {
            throw new \InvalidArgumentException(sprintf('The EncryptionProperty property can only contain items of type \StructType\EncryptionPropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EncryptionProperty[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\EncryptionPropertiesType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
