<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EncryptionMethodType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class EncryptionMethodType extends AbstractStructBase
{
    /**
     * The Algorithm
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Algorithm;
    /**
     * The KeySize
     * Meta information extracted from the WSDL
     * - base: integer
     * - minOccurs: 0
     * @var int
     */
    public $KeySize;
    /**
     * The OAEPparams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OAEPparams;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for EncryptionMethodType
     * @uses EncryptionMethodType::setAlgorithm()
     * @uses EncryptionMethodType::setKeySize()
     * @uses EncryptionMethodType::setOAEPparams()
     * @uses EncryptionMethodType::setAny()
     * @param string $algorithm
     * @param int $keySize
     * @param string $oAEPparams
     * @param \DOMDocument $any
     */
    public function __construct($algorithm = null, $keySize = null, $oAEPparams = null, \DOMDocument $any = null)
    {
        $this
            ->setAlgorithm($algorithm)
            ->setKeySize($keySize)
            ->setOAEPparams($oAEPparams)
            ->setAny($any);
    }
    /**
     * Get Algorithm value
     * @return string
     */
    public function getAlgorithm()
    {
        return $this->Algorithm;
    }
    /**
     * Set Algorithm value
     * @param string $algorithm
     * @return \StructType\EncryptionMethodType
     */
    public function setAlgorithm($algorithm = null)
    {
        // validation for constraint: string
        if (!is_null($algorithm) && !is_string($algorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($algorithm, true), gettype($algorithm)), __LINE__);
        }
        $this->Algorithm = $algorithm;
        return $this;
    }
    /**
     * Get KeySize value
     * @return int|null
     */
    public function getKeySize()
    {
        return $this->KeySize;
    }
    /**
     * Set KeySize value
     * @param int $keySize
     * @return \StructType\EncryptionMethodType
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: int
        if (!is_null($keySize) && !(is_int($keySize) || ctype_digit($keySize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keySize, true), gettype($keySize)), __LINE__);
        }
        $this->KeySize = $keySize;
        return $this;
    }
    /**
     * Get OAEPparams value
     * @return string|null
     */
    public function getOAEPparams()
    {
        return $this->OAEPparams;
    }
    /**
     * Set OAEPparams value
     * @param string $oAEPparams
     * @return \StructType\EncryptionMethodType
     */
    public function setOAEPparams($oAEPparams = null)
    {
        // validation for constraint: string
        if (!is_null($oAEPparams) && !is_string($oAEPparams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oAEPparams, true), gettype($oAEPparams)), __LINE__);
        }
        $this->OAEPparams = $oAEPparams;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\EncryptionMethodType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
